<?php
//
// WARNING: Do not edit by hand, this file was generated by Crank:
// https://github.com/gocardless/crank
//

namespace GoCardlessPro\Integration;

class CustomerBankAccountsIntegrationTest extends IntegrationTestBase
{
    public function testResourceModelExists()
    {
        $obj = new \GoCardlessPro\Resources\CustomerBankAccount(array());
        $this->assertNotNull($obj);
    }
    
    public function testCustomerBankAccountsCreate()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->create;
        $this->stub_request($fixture);

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);

        $body = $fixture->body->customer_bank_accounts;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $response);

        $this->assertEquals($body->account_holder_name, $response->account_holder_name);
        $this->assertEquals($body->account_number_ending, $response->account_number_ending);
        $this->assertEquals($body->bank_name, $response->bank_name);
        $this->assertEquals($body->country_code, $response->country_code);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->enabled, $response->enabled);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    public function testCustomerBankAccountsCreateWithIdempotencyConflict()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->create;

        $idempotencyConflictResponseFixture = $this->loadFixture('idempotent_creation_conflict_invalid_state_error');

        // The POST request responds with a 409 to our original POST, due to an idempotency conflict
        $this->mock->append(new \GuzzleHttp\Psr7\Response(409, [], $idempotencyConflictResponseFixture));

        // The client makes a second request to fetch the resource that was already
        // created using our idempotency key. It responds with the created resource,
        // which looks just like the response for a successful POST request.
        $this->mock->append(new \GuzzleHttp\Psr7\Response(200, [], json_encode($fixture->body)));

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'create'), (array)$fixture->url_params);
        $body = $fixture->body->customer_bank_accounts;

        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $response);

        $this->assertEquals($body->account_holder_name, $response->account_holder_name);
        $this->assertEquals($body->account_number_ending, $response->account_number_ending);
        $this->assertEquals($body->bank_name, $response->bank_name);
        $this->assertEquals($body->country_code, $response->country_code);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->enabled, $response->enabled);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
        

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $conflictRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $conflictRequest->getUri()->getPath());
        $getRequest = $this->history[1]['request'];
        $this->assertEquals($getRequest->getUri()->getPath(), '/customer_bank_accounts/ID123');
    }
    
    public function testCustomerBankAccountsList()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->list;
        $this->stub_request($fixture);

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'list'), (array)$fixture->url_params);

        $body = $fixture->body->customer_bank_accounts;
    
        $records = $response->records;
        $this->assertInstanceOf('\GoCardlessPro\Core\ListResponse', $response);
        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $records[0]);

        $this->assertEquals($fixture->body->meta->cursors->before, $response->before);
        $this->assertEquals($fixture->body->meta->cursors->after, $response->after);
    

    
        foreach (range(0, count($body) - 1) as $num) {
            $record = $records[$num];
            $this->assertEquals($body[$num]->account_holder_name, $record->account_holder_name);
            $this->assertEquals($body[$num]->account_number_ending, $record->account_number_ending);
            $this->assertEquals($body[$num]->bank_name, $record->bank_name);
            $this->assertEquals($body[$num]->country_code, $record->country_code);
            $this->assertEquals($body[$num]->created_at, $record->created_at);
            $this->assertEquals($body[$num]->currency, $record->currency);
            $this->assertEquals($body[$num]->enabled, $record->enabled);
            $this->assertEquals($body[$num]->id, $record->id);
            $this->assertEquals($body[$num]->links, $record->links);
            $this->assertEquals($body[$num]->metadata, $record->metadata);
            
        }

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testCustomerBankAccountsGet()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->get;
        $this->stub_request($fixture);

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'get'), (array)$fixture->url_params);

        $body = $fixture->body->customer_bank_accounts;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $response);

        $this->assertEquals($body->account_holder_name, $response->account_holder_name);
        $this->assertEquals($body->account_number_ending, $response->account_number_ending);
        $this->assertEquals($body->bank_name, $response->bank_name);
        $this->assertEquals($body->country_code, $response->country_code);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->enabled, $response->enabled);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testCustomerBankAccountsUpdate()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->update;
        $this->stub_request($fixture);

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'update'), (array)$fixture->url_params);

        $body = $fixture->body->customer_bank_accounts;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $response);

        $this->assertEquals($body->account_holder_name, $response->account_holder_name);
        $this->assertEquals($body->account_number_ending, $response->account_number_ending);
        $this->assertEquals($body->bank_name, $response->bank_name);
        $this->assertEquals($body->country_code, $response->country_code);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->enabled, $response->enabled);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    
    public function testCustomerBankAccountsDisable()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->disable;
        $this->stub_request($fixture);

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'disable'), (array)$fixture->url_params);

        $body = $fixture->body->customer_bank_accounts;
    
        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $response);

        $this->assertEquals($body->account_holder_name, $response->account_holder_name);
        $this->assertEquals($body->account_number_ending, $response->account_number_ending);
        $this->assertEquals($body->bank_name, $response->bank_name);
        $this->assertEquals($body->country_code, $response->country_code);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->enabled, $response->enabled);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
    

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $dispatchedRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $dispatchedRequest->getUri()->getPath());
    }

    public function testCustomerBankAccountsDisableWithIdempotencyConflict()
    {
        $fixture = $this->loadJsonFixture('customer_bank_accounts')->disable;

        $idempotencyConflictResponseFixture = $this->loadFixture('idempotent_creation_conflict_invalid_state_error');

        // The POST request responds with a 409 to our original POST, due to an idempotency conflict
        $this->mock->append(new \GuzzleHttp\Psr7\Response(409, [], $idempotencyConflictResponseFixture));

        // The client makes a second request to fetch the resource that was already
        // created using our idempotency key. It responds with the created resource,
        // which looks just like the response for a successful POST request.
        $this->mock->append(new \GuzzleHttp\Psr7\Response(200, [], json_encode($fixture->body)));

        $service = $this->client->customerBankAccounts();
        $response = call_user_func_array(array($service, 'disable'), (array)$fixture->url_params);
        $body = $fixture->body->customer_bank_accounts;

        $this->assertInstanceOf('\GoCardlessPro\Resources\CustomerBankAccount', $response);

        $this->assertEquals($body->account_holder_name, $response->account_holder_name);
        $this->assertEquals($body->account_number_ending, $response->account_number_ending);
        $this->assertEquals($body->bank_name, $response->bank_name);
        $this->assertEquals($body->country_code, $response->country_code);
        $this->assertEquals($body->created_at, $response->created_at);
        $this->assertEquals($body->currency, $response->currency);
        $this->assertEquals($body->enabled, $response->enabled);
        $this->assertEquals($body->id, $response->id);
        $this->assertEquals($body->links, $response->links);
        $this->assertEquals($body->metadata, $response->metadata);
        

        $expectedPathRegex = $this->extract_resource_fixture_path_regex($fixture);
        $conflictRequest = $this->history[0]['request'];
        $this->assertRegExp($expectedPathRegex, $conflictRequest->getUri()->getPath());
        $getRequest = $this->history[1]['request'];
        $this->assertEquals($getRequest->getUri()->getPath(), '/customer_bank_accounts/ID123');
    }
    
}
