<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/audit/audit_log.proto

namespace Google\Cloud\Audit;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Common audit log format for Google Cloud Platform API operations.
 *
 * Generated from protobuf message <code>google.cloud.audit.AuditLog</code>
 */
class AuditLog extends \Google\Protobuf\Internal\Message
{
    /**
     * The name of the API service performing the operation. For example,
     * `"datastore.googleapis.com"`.
     *
     * Generated from protobuf field <code>string service_name = 7;</code>
     */
    private $service_name = '';
    /**
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *     "google.datastore.v1.Datastore.RunQuery"
     *     "google.logging.v1.LoggingService.DeleteLog"
     *
     * Generated from protobuf field <code>string method_name = 8;</code>
     */
    private $method_name = '';
    /**
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *     "shelves/SHELF_ID/books"
     *     "shelves/SHELF_ID/books/BOOK_ID"
     *
     * Generated from protobuf field <code>string resource_name = 11;</code>
     */
    private $resource_name = '';
    /**
     * The number of items returned from a List or Query API method,
     * if applicable.
     *
     * Generated from protobuf field <code>int64 num_response_items = 12;</code>
     */
    private $num_response_items = 0;
    /**
     * The status of the overall operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     */
    private $status = null;
    /**
     * Authentication information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     */
    private $authentication_info = null;
    /**
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     */
    private $authorization_info;
    /**
     * Metadata about the operation.
     *
     * Generated from protobuf field <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     */
    private $request_metadata = null;
    /**
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct request = 16;</code>
     */
    private $request = null;
    /**
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 17;</code>
     */
    private $response = null;
    /**
     * Other service-specific data about the request, response, and other
     * activities.
     *
     * Generated from protobuf field <code>.google.protobuf.Any service_data = 15;</code>
     */
    private $service_data = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $service_name
     *           The name of the API service performing the operation. For example,
     *           `"datastore.googleapis.com"`.
     *     @type string $method_name
     *           The name of the service method or operation.
     *           For API calls, this should be the name of the API method.
     *           For example,
     *               "google.datastore.v1.Datastore.RunQuery"
     *               "google.logging.v1.LoggingService.DeleteLog"
     *     @type string $resource_name
     *           The resource or collection that is the target of the operation.
     *           The name is a scheme-less URI, not including the API service name.
     *           For example:
     *               "shelves/SHELF_ID/books"
     *               "shelves/SHELF_ID/books/BOOK_ID"
     *     @type int|string $num_response_items
     *           The number of items returned from a List or Query API method,
     *           if applicable.
     *     @type \Google\Rpc\Status $status
     *           The status of the overall operation.
     *     @type \Google\Cloud\Audit\AuthenticationInfo $authentication_info
     *           Authentication information.
     *     @type \Google\Cloud\Audit\AuthorizationInfo[]|\Google\Protobuf\Internal\RepeatedField $authorization_info
     *           Authorization information. If there are multiple
     *           resources or permissions involved, then there is
     *           one AuthorizationInfo element for each {resource, permission} tuple.
     *     @type \Google\Cloud\Audit\RequestMetadata $request_metadata
     *           Metadata about the operation.
     *     @type \Google\Protobuf\Struct $request
     *           The operation request. This may not include all request parameters,
     *           such as those that are too large, privacy-sensitive, or duplicated
     *           elsewhere in the log record.
     *           It should never include user-generated data, such as file contents.
     *           When the JSON object represented here has a proto equivalent, the proto
     *           name will be indicated in the `&#64;type` property.
     *     @type \Google\Protobuf\Struct $response
     *           The operation response. This may not include all response elements,
     *           such as those that are too large, privacy-sensitive, or duplicated
     *           elsewhere in the log record.
     *           It should never include user-generated data, such as file contents.
     *           When the JSON object represented here has a proto equivalent, the proto
     *           name will be indicated in the `&#64;type` property.
     *     @type \Google\Protobuf\Any $service_data
     *           Other service-specific data about the request, response, and other
     *           activities.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Audit\AuditLog::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the API service performing the operation. For example,
     * `"datastore.googleapis.com"`.
     *
     * Generated from protobuf field <code>string service_name = 7;</code>
     * @return string
     */
    public function getServiceName()
    {
        return $this->service_name;
    }

    /**
     * The name of the API service performing the operation. For example,
     * `"datastore.googleapis.com"`.
     *
     * Generated from protobuf field <code>string service_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_name = $var;

        return $this;
    }

    /**
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *     "google.datastore.v1.Datastore.RunQuery"
     *     "google.logging.v1.LoggingService.DeleteLog"
     *
     * Generated from protobuf field <code>string method_name = 8;</code>
     * @return string
     */
    public function getMethodName()
    {
        return $this->method_name;
    }

    /**
     * The name of the service method or operation.
     * For API calls, this should be the name of the API method.
     * For example,
     *     "google.datastore.v1.Datastore.RunQuery"
     *     "google.logging.v1.LoggingService.DeleteLog"
     *
     * Generated from protobuf field <code>string method_name = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setMethodName($var)
    {
        GPBUtil::checkString($var, True);
        $this->method_name = $var;

        return $this;
    }

    /**
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *     "shelves/SHELF_ID/books"
     *     "shelves/SHELF_ID/books/BOOK_ID"
     *
     * Generated from protobuf field <code>string resource_name = 11;</code>
     * @return string
     */
    public function getResourceName()
    {
        return $this->resource_name;
    }

    /**
     * The resource or collection that is the target of the operation.
     * The name is a scheme-less URI, not including the API service name.
     * For example:
     *     "shelves/SHELF_ID/books"
     *     "shelves/SHELF_ID/books/BOOK_ID"
     *
     * Generated from protobuf field <code>string resource_name = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setResourceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_name = $var;

        return $this;
    }

    /**
     * The number of items returned from a List or Query API method,
     * if applicable.
     *
     * Generated from protobuf field <code>int64 num_response_items = 12;</code>
     * @return int|string
     */
    public function getNumResponseItems()
    {
        return $this->num_response_items;
    }

    /**
     * The number of items returned from a List or Query API method,
     * if applicable.
     *
     * Generated from protobuf field <code>int64 num_response_items = 12;</code>
     * @param int|string $var
     * @return $this
     */
    public function setNumResponseItems($var)
    {
        GPBUtil::checkInt64($var);
        $this->num_response_items = $var;

        return $this;
    }

    /**
     * The status of the overall operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     * @return \Google\Rpc\Status
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * The status of the overall operation.
     *
     * Generated from protobuf field <code>.google.rpc.Status status = 2;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * Authentication information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     * @return \Google\Cloud\Audit\AuthenticationInfo
     */
    public function getAuthenticationInfo()
    {
        return $this->authentication_info;
    }

    /**
     * Authentication information.
     *
     * Generated from protobuf field <code>.google.cloud.audit.AuthenticationInfo authentication_info = 3;</code>
     * @param \Google\Cloud\Audit\AuthenticationInfo $var
     * @return $this
     */
    public function setAuthenticationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Audit\AuthenticationInfo::class);
        $this->authentication_info = $var;

        return $this;
    }

    /**
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAuthorizationInfo()
    {
        return $this->authorization_info;
    }

    /**
     * Authorization information. If there are multiple
     * resources or permissions involved, then there is
     * one AuthorizationInfo element for each {resource, permission} tuple.
     *
     * Generated from protobuf field <code>repeated .google.cloud.audit.AuthorizationInfo authorization_info = 9;</code>
     * @param \Google\Cloud\Audit\AuthorizationInfo[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAuthorizationInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Audit\AuthorizationInfo::class);
        $this->authorization_info = $arr;

        return $this;
    }

    /**
     * Metadata about the operation.
     *
     * Generated from protobuf field <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     * @return \Google\Cloud\Audit\RequestMetadata
     */
    public function getRequestMetadata()
    {
        return $this->request_metadata;
    }

    /**
     * Metadata about the operation.
     *
     * Generated from protobuf field <code>.google.cloud.audit.RequestMetadata request_metadata = 4;</code>
     * @param \Google\Cloud\Audit\RequestMetadata $var
     * @return $this
     */
    public function setRequestMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Audit\RequestMetadata::class);
        $this->request_metadata = $var;

        return $this;
    }

    /**
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct request = 16;</code>
     * @return \Google\Protobuf\Struct
     */
    public function getRequest()
    {
        return $this->request;
    }

    /**
     * The operation request. This may not include all request parameters,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct request = 16;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setRequest($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->request = $var;

        return $this;
    }

    /**
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 17;</code>
     * @return \Google\Protobuf\Struct
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * The operation response. This may not include all response elements,
     * such as those that are too large, privacy-sensitive, or duplicated
     * elsewhere in the log record.
     * It should never include user-generated data, such as file contents.
     * When the JSON object represented here has a proto equivalent, the proto
     * name will be indicated in the `&#64;type` property.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 17;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setResponse($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->response = $var;

        return $this;
    }

    /**
     * Other service-specific data about the request, response, and other
     * activities.
     *
     * Generated from protobuf field <code>.google.protobuf.Any service_data = 15;</code>
     * @return \Google\Protobuf\Any
     */
    public function getServiceData()
    {
        return $this->service_data;
    }

    /**
     * Other service-specific data about the request, response, and other
     * activities.
     *
     * Generated from protobuf field <code>.google.protobuf.Any service_data = 15;</code>
     * @param \Google\Protobuf\Any $var
     * @return $this
     */
    public function setServiceData($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Any::class);
        $this->service_data = $var;

        return $this;
    }

}

