<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Persistent Disk Snapshot resource.
 * You can use snapshots to back up data on a regular interval. For more information, read  Creating persistent disk snapshots. (== resource_for {$api_version}.snapshots ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.Snapshot</code>
 */
class Snapshot extends \Google\Protobuf\Internal\Message
{
    /**
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *
     * Generated from protobuf field <code>bool auto_created = 195486808;</code>
     */
    private $auto_created = false;
    /**
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *
     * Generated from protobuf field <code>string chain_name = 68644169;</code>
     */
    private $chain_name = '';
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * [Output Only] Size of the source disk, specified in GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     */
    private $disk_size_gb = '';
    /**
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *
     * Generated from protobuf field <code>string download_bytes = 166618612;</code>
     */
    private $download_bytes = '';
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     */
    private $label_fingerprint = '';
    /**
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     */
    private $labels;
    /**
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *
     * Generated from protobuf field <code>repeated string license_codes = 45482664;</code>
     */
    private $license_codes;
    /**
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     */
    private $licenses;
    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * Encrypts the snapshot using a customer-supplied encryption key.
     * After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request.
     * Customer-supplied encryption keys do not protect access to metadata of the snapshot.
     * If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;</code>
     */
    private $snapshot_encryption_key = null;
    /**
     * The source disk used to create this snapshot.
     *
     * Generated from protobuf field <code>string source_disk = 183318337;</code>
     */
    private $source_disk = '';
    /**
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 263065697;</code>
     */
    private $source_disk_encryption_key = null;
    /**
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *
     * Generated from protobuf field <code>string source_disk_id = 185755353;</code>
     */
    private $source_disk_id = '';
    /**
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Snapshot.Status status = 181260274;</code>
     */
    private $status = 0;
    /**
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *
     * Generated from protobuf field <code>string storage_bytes = 156196263;</code>
     */
    private $storage_bytes = '';
    /**
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Snapshot.StorageBytesStatus storage_bytes_status = 222303626;</code>
     */
    private $storage_bytes_status = 0;
    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 59569818;</code>
     */
    private $storage_locations;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $auto_created
     *           [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *     @type string $chain_name
     *           Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type string $disk_size_gb
     *           [Output Only] Size of the source disk, specified in GB.
     *     @type string $download_bytes
     *           [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *     @type string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *     @type string $label_fingerprint
     *           A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     *           To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $license_codes
     *           [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $licenses
     *           [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *     @type string $name
     *           Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $snapshot_encryption_key
     *           Encrypts the snapshot using a customer-supplied encryption key.
     *           After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request.
     *           Customer-supplied encryption keys do not protect access to metadata of the snapshot.
     *           If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *     @type string $source_disk
     *           The source disk used to create this snapshot.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $source_disk_encryption_key
     *           The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *     @type string $source_disk_id
     *           [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *     @type int $status
     *           [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     *     @type string $storage_bytes
     *           [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *     @type int $storage_bytes_status
     *           [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $storage_locations
     *           Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *
     * Generated from protobuf field <code>bool auto_created = 195486808;</code>
     * @return bool
     */
    public function getAutoCreated()
    {
        return $this->auto_created;
    }

    /**
     * [Output Only] Set to true if snapshots are automatically created by applying resource policy on the target disk.
     *
     * Generated from protobuf field <code>bool auto_created = 195486808;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoCreated($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_created = $var;

        return $this;
    }

    /**
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *
     * Generated from protobuf field <code>string chain_name = 68644169;</code>
     * @return string
     */
    public function getChainName()
    {
        return $this->chain_name;
    }

    /**
     * Creates the new snapshot in the snapshot chain labeled with the specified name. The chain name must be 1-63 characters long and comply with RFC1035. This is an uncommon option only for advanced service owners who needs to create separate snapshot chains, for example, for chargeback tracking. When you describe your snapshot resource, this field is visible only if it has a non-empty value.
     *
     * Generated from protobuf field <code>string chain_name = 68644169;</code>
     * @param string $var
     * @return $this
     */
    public function setChainName($var)
    {
        GPBUtil::checkString($var, True);
        $this->chain_name = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * [Output Only] Size of the source disk, specified in GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     * @return string
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * [Output Only] Size of the source disk, specified in GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *
     * Generated from protobuf field <code>string download_bytes = 166618612;</code>
     * @return string
     */
    public function getDownloadBytes()
    {
        return $this->download_bytes;
    }

    /**
     * [Output Only] Number of bytes downloaded to restore a snapshot to a disk.
     *
     * Generated from protobuf field <code>string download_bytes = 166618612;</code>
     * @param string $var
     * @return $this
     */
    public function setDownloadBytes($var)
    {
        GPBUtil::checkString($var, True);
        $this->download_bytes = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#snapshot for Snapshot resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     * @return string
     */
    public function getLabelFingerprint()
    {
        return $this->label_fingerprint;
    }

    /**
     * A fingerprint for the labels being applied to this snapshot, which is essentially a hash of the labels set used for optimistic locking. The fingerprint is initially generated by Compute Engine and changes after every request to modify or update labels. You must always provide an up-to-date fingerprint hash in order to update or change labels, otherwise the request will fail with error 412 conditionNotMet.
     * To see the latest fingerprint, make a get() request to retrieve a snapshot.
     *
     * Generated from protobuf field <code>string label_fingerprint = 178124825;</code>
     * @param string $var
     * @return $this
     */
    public function setLabelFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->label_fingerprint = $var;

        return $this;
    }

    /**
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to this snapshot. These can be later modified by the setLabels method. Label values may be empty.
     *
     * Generated from protobuf field <code>map<string, string> labels = 231759871;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *
     * Generated from protobuf field <code>repeated string license_codes = 45482664;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenseCodes()
    {
        return $this->license_codes;
    }

    /**
     * [Output Only] Integer license codes indicating which licenses are attached to this snapshot.
     *
     * Generated from protobuf field <code>repeated string license_codes = 45482664;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenseCodes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->license_codes = $arr;

        return $this;
    }

    /**
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * [Output Only] A list of public visible licenses that apply to this snapshot. This can be because the original image had licenses attached (such as a Windows image).
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Encrypts the snapshot using a customer-supplied encryption key.
     * After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request.
     * Customer-supplied encryption keys do not protect access to metadata of the snapshot.
     * If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getSnapshotEncryptionKey()
    {
        return isset($this->snapshot_encryption_key) ? $this->snapshot_encryption_key : null;
    }

    public function hasSnapshotEncryptionKey()
    {
        return isset($this->snapshot_encryption_key);
    }

    public function clearSnapshotEncryptionKey()
    {
        unset($this->snapshot_encryption_key);
    }

    /**
     * Encrypts the snapshot using a customer-supplied encryption key.
     * After you encrypt a snapshot using a customer-supplied key, you must provide the same key if you use the snapshot later. For example, you must provide the encryption key when you create a disk from the encrypted snapshot in a future request.
     * Customer-supplied encryption keys do not protect access to metadata of the snapshot.
     * If you do not provide an encryption key when creating the snapshot, then the snapshot will be encrypted using an automatically generated key and you do not need to provide a key to use the snapshot later.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey snapshot_encryption_key = 43334526;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSnapshotEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->snapshot_encryption_key = $var;

        return $this;
    }

    /**
     * The source disk used to create this snapshot.
     *
     * Generated from protobuf field <code>string source_disk = 183318337;</code>
     * @return string
     */
    public function getSourceDisk()
    {
        return $this->source_disk;
    }

    /**
     * The source disk used to create this snapshot.
     *
     * Generated from protobuf field <code>string source_disk = 183318337;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDisk($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk = $var;

        return $this;
    }

    /**
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 263065697;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getSourceDiskEncryptionKey()
    {
        return isset($this->source_disk_encryption_key) ? $this->source_disk_encryption_key : null;
    }

    public function hasSourceDiskEncryptionKey()
    {
        return isset($this->source_disk_encryption_key);
    }

    public function clearSourceDiskEncryptionKey()
    {
        unset($this->source_disk_encryption_key);
    }

    /**
     * The customer-supplied encryption key of the source disk. Required if the source disk is protected by a customer-supplied encryption key.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey source_disk_encryption_key = 263065697;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setSourceDiskEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->source_disk_encryption_key = $var;

        return $this;
    }

    /**
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *
     * Generated from protobuf field <code>string source_disk_id = 185755353;</code>
     * @return string
     */
    public function getSourceDiskId()
    {
        return $this->source_disk_id;
    }

    /**
     * [Output Only] The ID value of the disk used to create this snapshot. This value may be used to determine whether the snapshot was taken from the current or a previous instance of a given disk name.
     *
     * Generated from protobuf field <code>string source_disk_id = 185755353;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceDiskId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_disk_id = $var;

        return $this;
    }

    /**
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Snapshot.Status status = 181260274;</code>
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * [Output Only] The status of the snapshot. This can be CREATING, DELETING, FAILED, READY, or UPLOADING.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Snapshot.Status status = 181260274;</code>
     * @param int $var
     * @return $this
     */
    public function setStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Snapshot\Status::class);
        $this->status = $var;

        return $this;
    }

    /**
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *
     * Generated from protobuf field <code>string storage_bytes = 156196263;</code>
     * @return string
     */
    public function getStorageBytes()
    {
        return $this->storage_bytes;
    }

    /**
     * [Output Only] A size of the storage used by the snapshot. As snapshots share storage, this number is expected to change with snapshot creation/deletion.
     *
     * Generated from protobuf field <code>string storage_bytes = 156196263;</code>
     * @param string $var
     * @return $this
     */
    public function setStorageBytes($var)
    {
        GPBUtil::checkString($var, True);
        $this->storage_bytes = $var;

        return $this;
    }

    /**
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Snapshot.StorageBytesStatus storage_bytes_status = 222303626;</code>
     * @return int
     */
    public function getStorageBytesStatus()
    {
        return $this->storage_bytes_status;
    }

    /**
     * [Output Only] An indicator whether storageBytes is in a stable state or it is being adjusted as a result of shared storage reallocation. This status can either be UPDATING, meaning the size of the snapshot is being updated, or UP_TO_DATE, meaning the size of the snapshot is up-to-date.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.Snapshot.StorageBytesStatus storage_bytes_status = 222303626;</code>
     * @param int $var
     * @return $this
     */
    public function setStorageBytesStatus($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\Snapshot\StorageBytesStatus::class);
        $this->storage_bytes_status = $var;

        return $this;
    }

    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 59569818;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getStorageLocations()
    {
        return $this->storage_locations;
    }

    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Generated from protobuf field <code>repeated string storage_locations = 59569818;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setStorageLocations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->storage_locations = $arr;

        return $this;
    }

}

