<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/privacy/dlp/v2/dlp.proto

namespace Google\Cloud\Dlp\V2\RedactImageRequest;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for determining how redaction of images should occur.
 *
 * Generated from protobuf message <code>google.privacy.dlp.v2.RedactImageRequest.ImageRedactionConfig</code>
 */
class ImageRedactionConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     */
    private $redaction_color = null;
    protected $target;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Dlp\V2\InfoType $info_type
     *           Only one per info_type should be provided per request. If not
     *           specified, and redact_all_text is false, the DLP API will redact all
     *           text that it matches against all info_types that are found, but not
     *           specified in another ImageRedactionConfig.
     *     @type bool $redact_all_text
     *           If true, all text found in the image, regardless whether it matches an
     *           info_type, is redacted. Only one should be provided.
     *     @type \Google\Cloud\Dlp\V2\Color $redaction_color
     *           The color to use when redacting content from an image. If not specified,
     *           the default is black.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Privacy\Dlp\V2\Dlp::initOnce();
        parent::__construct($data);
    }

    /**
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     * @return \Google\Cloud\Dlp\V2\InfoType
     */
    public function getInfoType()
    {
        return $this->readOneof(1);
    }

    public function hasInfoType()
    {
        return $this->hasOneof(1);
    }

    /**
     * Only one per info_type should be provided per request. If not
     * specified, and redact_all_text is false, the DLP API will redact all
     * text that it matches against all info_types that are found, but not
     * specified in another ImageRedactionConfig.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.InfoType info_type = 1;</code>
     * @param \Google\Cloud\Dlp\V2\InfoType $var
     * @return $this
     */
    public function setInfoType($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\InfoType::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * If true, all text found in the image, regardless whether it matches an
     * info_type, is redacted. Only one should be provided.
     *
     * Generated from protobuf field <code>bool redact_all_text = 2;</code>
     * @return bool
     */
    public function getRedactAllText()
    {
        return $this->readOneof(2);
    }

    public function hasRedactAllText()
    {
        return $this->hasOneof(2);
    }

    /**
     * If true, all text found in the image, regardless whether it matches an
     * info_type, is redacted. Only one should be provided.
     *
     * Generated from protobuf field <code>bool redact_all_text = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setRedactAllText($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     * @return \Google\Cloud\Dlp\V2\Color
     */
    public function getRedactionColor()
    {
        return isset($this->redaction_color) ? $this->redaction_color : null;
    }

    public function hasRedactionColor()
    {
        return isset($this->redaction_color);
    }

    public function clearRedactionColor()
    {
        unset($this->redaction_color);
    }

    /**
     * The color to use when redacting content from an image. If not specified,
     * the default is black.
     *
     * Generated from protobuf field <code>.google.privacy.dlp.v2.Color redaction_color = 3;</code>
     * @param \Google\Cloud\Dlp\V2\Color $var
     * @return $this
     */
    public function setRedactionColor($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dlp\V2\Color::class);
        $this->redaction_color = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTarget()
    {
        return $this->whichOneof("target");
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ImageRedactionConfig::class, \Google\Cloud\Dlp\V2\RedactImageRequest_ImageRedactionConfig::class);

