<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An instance-attached disk resource.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.AttachedDisk</code>
 */
class AttachedDisk extends \Google\Protobuf\Internal\Message
{
    /**
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>bool auto_delete = 196325947;</code>
     */
    private $auto_delete = false;
    /**
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     *
     * Generated from protobuf field <code>bool boot = 3029746;</code>
     */
    private $boot = false;
    /**
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.
     * If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>string device_name = 67541716;</code>
     */
    private $device_name = '';
    /**
     * Encrypts or decrypts a disk using a customer-supplied encryption key.
     * If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.
     * If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.
     * If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     * Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 3225221;</code>
     */
    private $disk_encryption_key = null;
    /**
     * The size of the disk in GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     */
    private $disk_size_gb = '';
    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     */
    private $guest_os_features;
    /**
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     *
     * Generated from protobuf field <code>int32 index = 100346066;</code>
     */
    private $index = 0;
    /**
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
     * This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;</code>
     */
    private $initialize_params = null;
    /**
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Interface interface = 234188089;</code>
     */
    private $interface = 0;
    /**
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * [Output Only] Any valid publicly visible licenses.
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     */
    private $licenses;
    /**
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Mode mode = 3357091;</code>
     */
    private $mode = 0;
    /**
     * [Output Only] shielded vm initial state stored on disk
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;</code>
     */
    private $shielded_instance_initial_state = null;
    /**
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     * If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.
     * Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
     *
     * Generated from protobuf field <code>string source = 177235995;</code>
     */
    private $source = '';
    /**
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Type type = 3575610;</code>
     */
    private $type = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $auto_delete
     *           Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     *     @type bool $boot
     *           Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     *     @type string $device_name
     *           Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.
     *           If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     *     @type \Google\Cloud\Compute\V1\CustomerEncryptionKey $disk_encryption_key
     *           Encrypts or decrypts a disk using a customer-supplied encryption key.
     *           If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.
     *           If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.
     *           If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     *           Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     *     @type string $disk_size_gb
     *           The size of the disk in GB.
     *     @type \Google\Cloud\Compute\V1\GuestOsFeature[]|\Google\Protobuf\Internal\RepeatedField $guest_os_features
     *           A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *     @type int $index
     *           [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     *     @type \Google\Cloud\Compute\V1\AttachedDiskInitializeParams $initialize_params
     *           [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
     *           This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     *     @type int $interface
     *           Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $licenses
     *           [Output Only] Any valid publicly visible licenses.
     *     @type int $mode
     *           The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     *     @type \Google\Cloud\Compute\V1\InitialStateConfig $shielded_instance_initial_state
     *           [Output Only] shielded vm initial state stored on disk
     *     @type string $source
     *           Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     *           If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.
     *           Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
     *     @type int $type
     *           Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>bool auto_delete = 196325947;</code>
     * @return bool
     */
    public function getAutoDelete()
    {
        return $this->auto_delete;
    }

    /**
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     *
     * Generated from protobuf field <code>bool auto_delete = 196325947;</code>
     * @param bool $var
     * @return $this
     */
    public function setAutoDelete($var)
    {
        GPBUtil::checkBool($var);
        $this->auto_delete = $var;

        return $this;
    }

    /**
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     *
     * Generated from protobuf field <code>bool boot = 3029746;</code>
     * @return bool
     */
    public function getBoot()
    {
        return $this->boot;
    }

    /**
     * Indicates that this is a boot disk. The virtual machine will use the first partition of the disk for its root filesystem.
     *
     * Generated from protobuf field <code>bool boot = 3029746;</code>
     * @param bool $var
     * @return $this
     */
    public function setBoot($var)
    {
        GPBUtil::checkBool($var);
        $this->boot = $var;

        return $this;
    }

    /**
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.
     * If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>string device_name = 67541716;</code>
     * @return string
     */
    public function getDeviceName()
    {
        return $this->device_name;
    }

    /**
     * Specifies a unique device name of your choice that is reflected into the /dev/disk/by-id/google-* tree of a Linux operating system running within the instance. This name can be used to reference the device for mounting, resizing, and so on, from within the instance.
     * If not specified, the server chooses a default device name to apply to this disk, in the form persistent-disk-x, where x is a number assigned by Google Compute Engine. This field is only applicable for persistent disks.
     *
     * Generated from protobuf field <code>string device_name = 67541716;</code>
     * @param string $var
     * @return $this
     */
    public function setDeviceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->device_name = $var;

        return $this;
    }

    /**
     * Encrypts or decrypts a disk using a customer-supplied encryption key.
     * If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.
     * If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.
     * If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     * Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 3225221;</code>
     * @return \Google\Cloud\Compute\V1\CustomerEncryptionKey
     */
    public function getDiskEncryptionKey()
    {
        return isset($this->disk_encryption_key) ? $this->disk_encryption_key : null;
    }

    public function hasDiskEncryptionKey()
    {
        return isset($this->disk_encryption_key);
    }

    public function clearDiskEncryptionKey()
    {
        unset($this->disk_encryption_key);
    }

    /**
     * Encrypts or decrypts a disk using a customer-supplied encryption key.
     * If you are creating a new disk, this field encrypts the new disk using an encryption key that you provide. If you are attaching an existing disk that is already encrypted, this field decrypts the disk using the customer-supplied encryption key.
     * If you encrypt a disk using a customer-supplied key, you must provide the same key again when you attempt to use this resource at a later time. For example, you must provide the key when you create a snapshot or an image from the disk or when you attach the disk to a virtual machine instance.
     * If you do not provide an encryption key, then the disk will be encrypted using an automatically generated key and you do not need to provide a key to use the disk later.
     * Instance templates do not store customer-supplied encryption keys, so you cannot use your own keys to encrypt disks in a managed instance group.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.CustomerEncryptionKey disk_encryption_key = 3225221;</code>
     * @param \Google\Cloud\Compute\V1\CustomerEncryptionKey $var
     * @return $this
     */
    public function setDiskEncryptionKey($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\CustomerEncryptionKey::class);
        $this->disk_encryption_key = $var;

        return $this;
    }

    /**
     * The size of the disk in GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     * @return string
     */
    public function getDiskSizeGb()
    {
        return $this->disk_size_gb;
    }

    /**
     * The size of the disk in GB.
     *
     * Generated from protobuf field <code>string disk_size_gb = 47828279;</code>
     * @param string $var
     * @return $this
     */
    public function setDiskSizeGb($var)
    {
        GPBUtil::checkString($var, True);
        $this->disk_size_gb = $var;

        return $this;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGuestOsFeatures()
    {
        return $this->guest_os_features;
    }

    /**
     * A list of features to enable on the guest operating system. Applicable only for bootable images. Read  Enabling guest operating system features to see a list of available options.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.GuestOsFeature guest_os_features = 79294545;</code>
     * @param \Google\Cloud\Compute\V1\GuestOsFeature[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGuestOsFeatures($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\GuestOsFeature::class);
        $this->guest_os_features = $arr;

        return $this;
    }

    /**
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     *
     * Generated from protobuf field <code>int32 index = 100346066;</code>
     * @return int
     */
    public function getIndex()
    {
        return $this->index;
    }

    /**
     * [Output Only] A zero-based index to this disk, where 0 is reserved for the boot disk. If you have many disks attached to an instance, each disk would have a unique index number.
     *
     * Generated from protobuf field <code>int32 index = 100346066;</code>
     * @param int $var
     * @return $this
     */
    public function setIndex($var)
    {
        GPBUtil::checkInt32($var);
        $this->index = $var;

        return $this;
    }

    /**
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
     * This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;</code>
     * @return \Google\Cloud\Compute\V1\AttachedDiskInitializeParams
     */
    public function getInitializeParams()
    {
        return isset($this->initialize_params) ? $this->initialize_params : null;
    }

    public function hasInitializeParams()
    {
        return isset($this->initialize_params);
    }

    public function clearInitializeParams()
    {
        unset($this->initialize_params);
    }

    /**
     * [Input Only] Specifies the parameters for a new disk that will be created alongside the new instance. Use initialization parameters to create boot disks or local SSDs attached to the new instance.
     * This property is mutually exclusive with the source property; you can only define one or the other, but not both.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDiskInitializeParams initialize_params = 17697045;</code>
     * @param \Google\Cloud\Compute\V1\AttachedDiskInitializeParams $var
     * @return $this
     */
    public function setInitializeParams($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\AttachedDiskInitializeParams::class);
        $this->initialize_params = $var;

        return $this;
    }

    /**
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Interface interface = 234188089;</code>
     * @return int
     */
    public function getInterface()
    {
        return $this->interface;
    }

    /**
     * Specifies the disk interface to use for attaching this disk, which is either SCSI or NVME. The default is SCSI. Persistent disks must always use SCSI and the request will fail if you attempt to attach a persistent disk in any other format than SCSI. Local SSDs can use either NVME or SCSI. For performance characteristics of SCSI over NVMe, see Local SSD performance.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Interface interface = 234188089;</code>
     * @param int $var
     * @return $this
     */
    public function setInterface($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\AttachedDisk\PBInterface::class);
        $this->interface = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#attachedDisk for attached disks.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * [Output Only] Any valid publicly visible licenses.
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLicenses()
    {
        return $this->licenses;
    }

    /**
     * [Output Only] Any valid publicly visible licenses.
     *
     * Generated from protobuf field <code>repeated string licenses = 69207122;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLicenses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->licenses = $arr;

        return $this;
    }

    /**
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Mode mode = 3357091;</code>
     * @return int
     */
    public function getMode()
    {
        return $this->mode;
    }

    /**
     * The mode in which to attach this disk, either READ_WRITE or READ_ONLY. If not specified, the default is to attach the disk in READ_WRITE mode.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Mode mode = 3357091;</code>
     * @param int $var
     * @return $this
     */
    public function setMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\AttachedDisk\Mode::class);
        $this->mode = $var;

        return $this;
    }

    /**
     * [Output Only] shielded vm initial state stored on disk
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;</code>
     * @return \Google\Cloud\Compute\V1\InitialStateConfig
     */
    public function getShieldedInstanceInitialState()
    {
        return isset($this->shielded_instance_initial_state) ? $this->shielded_instance_initial_state : null;
    }

    public function hasShieldedInstanceInitialState()
    {
        return isset($this->shielded_instance_initial_state);
    }

    public function clearShieldedInstanceInitialState()
    {
        unset($this->shielded_instance_initial_state);
    }

    /**
     * [Output Only] shielded vm initial state stored on disk
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.InitialStateConfig shielded_instance_initial_state = 192356867;</code>
     * @param \Google\Cloud\Compute\V1\InitialStateConfig $var
     * @return $this
     */
    public function setShieldedInstanceInitialState($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\InitialStateConfig::class);
        $this->shielded_instance_initial_state = $var;

        return $this;
    }

    /**
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     * If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.
     * Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
     *
     * Generated from protobuf field <code>string source = 177235995;</code>
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * Specifies a valid partial or full URL to an existing Persistent Disk resource. When creating a new instance, one of initializeParams.sourceImage or initializeParams.sourceSnapshot or disks.source is required except for local SSD.
     * If desired, you can also attach existing non-root persistent disks using this property. This field is only applicable for persistent disks.
     * Note that for InstanceTemplate, specify the disk name, not the URL for the disk.
     *
     * Generated from protobuf field <code>string source = 177235995;</code>
     * @param string $var
     * @return $this
     */
    public function setSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->source = $var;

        return $this;
    }

    /**
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Type type = 3575610;</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Specifies the type of the disk, either SCRATCH or PERSISTENT. If not specified, the default is PERSISTENT.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.AttachedDisk.Type type = 3575610;</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\AttachedDisk\Type::class);
        $this->type = $var;

        return $this;
    }

}

