<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/patch_jobs.proto

namespace Google\Cloud\OsConfig\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A filter to target VM instances for patching. The targeted
 * VMs must meet all criteria specified. So if both labels and zones are
 * specified, the patch job targets only VMs with those labels and in those
 * zones.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.PatchInstanceFilter</code>
 */
class PatchInstanceFilter extends \Google\Protobuf\Internal\Message
{
    /**
     * Target all VM instances in the project. If true, no other criteria is
     * permitted.
     *
     * Generated from protobuf field <code>bool all = 1;</code>
     */
    private $all = false;
    /**
     * Targets VM instances matching ANY of these GroupLabels. This allows
     * targeting of disparate groups of VM instances.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel group_labels = 2;</code>
     */
    private $group_labels;
    /**
     * Targets VM instances in ANY of these zones. Leave empty to target VM
     * instances in any zone.
     *
     * Generated from protobuf field <code>repeated string zones = 3;</code>
     */
    private $zones;
    /**
     * Targets any of the VM instances specified. Instances are specified by their
     * URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`,
     * `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
     * `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
     *
     * Generated from protobuf field <code>repeated string instances = 4;</code>
     */
    private $instances;
    /**
     * Targets VMs whose name starts with one of these prefixes. Similar to
     * labels, this is another way to group VMs when targeting configs, for
     * example prefix="prod-".
     *
     * Generated from protobuf field <code>repeated string instance_name_prefixes = 5;</code>
     */
    private $instance_name_prefixes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $all
     *           Target all VM instances in the project. If true, no other criteria is
     *           permitted.
     *     @type \Google\Cloud\OsConfig\V1\PatchInstanceFilter\GroupLabel[]|\Google\Protobuf\Internal\RepeatedField $group_labels
     *           Targets VM instances matching ANY of these GroupLabels. This allows
     *           targeting of disparate groups of VM instances.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $zones
     *           Targets VM instances in ANY of these zones. Leave empty to target VM
     *           instances in any zone.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $instances
     *           Targets any of the VM instances specified. Instances are specified by their
     *           URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`,
     *           `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
     *           `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $instance_name_prefixes
     *           Targets VMs whose name starts with one of these prefixes. Similar to
     *           labels, this is another way to group VMs when targeting configs, for
     *           example prefix="prod-".
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\PatchJobs::initOnce();
        parent::__construct($data);
    }

    /**
     * Target all VM instances in the project. If true, no other criteria is
     * permitted.
     *
     * Generated from protobuf field <code>bool all = 1;</code>
     * @return bool
     */
    public function getAll()
    {
        return $this->all;
    }

    /**
     * Target all VM instances in the project. If true, no other criteria is
     * permitted.
     *
     * Generated from protobuf field <code>bool all = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setAll($var)
    {
        GPBUtil::checkBool($var);
        $this->all = $var;

        return $this;
    }

    /**
     * Targets VM instances matching ANY of these GroupLabels. This allows
     * targeting of disparate groups of VM instances.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel group_labels = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getGroupLabels()
    {
        return $this->group_labels;
    }

    /**
     * Targets VM instances matching ANY of these GroupLabels. This allows
     * targeting of disparate groups of VM instances.
     *
     * Generated from protobuf field <code>repeated .google.cloud.osconfig.v1.PatchInstanceFilter.GroupLabel group_labels = 2;</code>
     * @param \Google\Cloud\OsConfig\V1\PatchInstanceFilter\GroupLabel[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setGroupLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\OsConfig\V1\PatchInstanceFilter\GroupLabel::class);
        $this->group_labels = $arr;

        return $this;
    }

    /**
     * Targets VM instances in ANY of these zones. Leave empty to target VM
     * instances in any zone.
     *
     * Generated from protobuf field <code>repeated string zones = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getZones()
    {
        return $this->zones;
    }

    /**
     * Targets VM instances in ANY of these zones. Leave empty to target VM
     * instances in any zone.
     *
     * Generated from protobuf field <code>repeated string zones = 3;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setZones($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->zones = $arr;

        return $this;
    }

    /**
     * Targets any of the VM instances specified. Instances are specified by their
     * URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`,
     * `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
     * `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
     *
     * Generated from protobuf field <code>repeated string instances = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInstances()
    {
        return $this->instances;
    }

    /**
     * Targets any of the VM instances specified. Instances are specified by their
     * URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`,
     * `projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`, or
     * `https://www.googleapis.com/compute/v1/projects/[PROJECT_ID]/zones/[ZONE]/instances/[INSTANCE_NAME]`
     *
     * Generated from protobuf field <code>repeated string instances = 4;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInstances($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->instances = $arr;

        return $this;
    }

    /**
     * Targets VMs whose name starts with one of these prefixes. Similar to
     * labels, this is another way to group VMs when targeting configs, for
     * example prefix="prod-".
     *
     * Generated from protobuf field <code>repeated string instance_name_prefixes = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getInstanceNamePrefixes()
    {
        return $this->instance_name_prefixes;
    }

    /**
     * Targets VMs whose name starts with one of these prefixes. Similar to
     * labels, this is another way to group VMs when targeting configs, for
     * example prefix="prod-".
     *
     * Generated from protobuf field <code>repeated string instance_name_prefixes = 5;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setInstanceNamePrefixes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->instance_name_prefixes = $arr;

        return $this;
    }

}

