<tr>
    <td><?php echo e(trans('texts.client')); ?></td>
    <td><?php echo e(trans('texts.email')); ?></td>
    <?php if($multiUser): ?>
        <td><?php echo e(trans('texts.user')); ?></td>
    <?php endif; ?>
    <td><?php echo e(trans(isset($entityType) && $entityType == ENTITY_QUOTE ? 'texts.quote_number' : 'texts.invoice_number')); ?></td>
    <td><?php echo e(trans('texts.amount')); ?></td>
    <td><?php echo e(trans('texts.paid')); ?></td>
    <td><?php echo e(trans('texts.po_number')); ?></td>
    <td><?php echo e(trans('texts.status')); ?></td>
    <td><?php echo e(trans(isset($entityType) && $entityType == ENTITY_QUOTE ? 'texts.quote_date' : 'texts.invoice_date')); ?></td>
    <td><?php echo e(trans('texts.due_date')); ?></td>
    <td><?php echo e(trans('texts.discount')); ?></td>
    <?php if(empty($entityType)): ?>
        <td><?php echo e(trans('texts.partial')); ?></td>
        <td><?php echo e(trans('texts.partial_due_date')); ?></td>
    <?php endif; ?>
    <td><?php echo e(trans('texts.public_notes')); ?></td>
    <td><?php echo e(trans('texts.private_notes')); ?></td>
    <?php if($account->customLabel('invoice1')): ?>
        <td><?php echo e($account->present()->customLabel('invoice1')); ?></td>
    <?php endif; ?>
    <?php if($account->customLabel('invoice2')): ?>
        <td><?php echo e($account->present()->customLabel('invoice2')); ?></td>
    <?php endif; ?>
    <?php if($account->customLabel('invoice_text1')): ?>
        <td><?php echo e($account->present()->customLabel('invoice_text1')); ?></td>
    <?php endif; ?>
    <?php if($account->customLabel('invoice_text2')): ?>
        <td><?php echo e($account->present()->customLabel('invoice_text2')); ?></td>
    <?php endif; ?>
    <td><?php echo e(trans('texts.item_product')); ?></td>
    <td><?php echo e(trans('texts.item_notes')); ?></td>
    <?php if($account->customLabel('product1')): ?>
        <td><?php echo e($account->present()->customLabel('product1')); ?></td>
    <?php endif; ?>
    <?php if($account->customLabel('product2')): ?>
        <td><?php echo e($account->present()->customLabel('product2')); ?></td>
    <?php endif; ?>
    <td><?php echo e(trans('texts.item_cost')); ?></td>
    <td><?php echo e(trans('texts.item_quantity')); ?></td>
    <?php if($account->invoice_item_taxes): ?>
        <td><?php echo e(trans('texts.item_tax_name')); ?></td>
        <td><?php echo e(trans('texts.item_tax_rate')); ?></td>
        <?php if($account->enable_second_tax_rate): ?>
            <td><?php echo e(trans('texts.item_tax_name')); ?></td>
            <td><?php echo e(trans('texts.item_tax_rate')); ?></td>
        <?php endif; ?>
    <?php endif; ?>
</tr>

<?php $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(!$invoice->client->is_deleted): ?>
        <?php $__currentLoopData = $invoice->invoice_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($invoice->present()->client); ?></td>
                <td><?php echo e($invoice->present()->email); ?></td>
                <?php if($multiUser): ?>
                    <td><?php echo e($invoice->present()->user); ?></td>
                <?php endif; ?>
                <td><?php echo e($invoice->invoice_number); ?></td>
                <td><?php echo e($account->formatMoney($invoice->amount, $invoice->client)); ?></td>
                <td><?php echo e($account->formatMoney($invoice->amount - $invoice->balance, $invoice->client)); ?></td>
                <td><?php echo e($invoice->po_number); ?></td>
                <td><?php echo e($invoice->present()->status); ?></td>
                <td><?php echo e($invoice->invoice_date); ?></td>
                <td><?php echo e($invoice->due_date); ?></td>
                <td><?php echo e($invoice->discount == 0 ? '' :
                    ($invoice->is_amount_discount
                        ? $account->formatMoney($invoice->discount, $invoice->client)
                        : $invoice->discount . '%')); ?></td>
                <?php if(empty($entityType)): ?>
                    <td><?php echo e($invoice->present()->partial); ?></td>
                    <td><?php echo e($invoice->partial_due_date); ?></td>
                <?php endif; ?>
                <td><?php echo e($invoice->public_notes); ?></td>
                <td><?php echo e($invoice->private_notes); ?></td>
                <?php if($account->customLabel('invoice1')): ?>
                    <td><?php echo e($invoice->custom_value1); ?></td>
                <?php endif; ?>
                <?php if($account->customLabel('invoice2')): ?>
                    <td><?php echo e($invoice->custom_value2); ?></td>
                <?php endif; ?>
                <?php if($account->customLabel('invoice_text1')): ?>
                    <td><?php echo e($invoice->custom_text_value1); ?></td>
                <?php endif; ?>
                <?php if($account->customLabel('invoice_text2')): ?>
                    <td><?php echo e($invoice->custom_text_value2); ?></td>
                <?php endif; ?>
                <td><?php echo e($item->product_key); ?></td>
                <td><?php echo e($item->notes); ?></td>
                <?php if($account->customLabel('product1')): ?>
                    <td><?php echo e($item->custom_value1); ?></td>
                <?php endif; ?>
                <?php if($account->customLabel('product2')): ?>
                    <td><?php echo e($item->custom_value2); ?></td>
                <?php endif; ?>
                <td><?php echo e($item->cost); ?></td>
                <td><?php echo e($item->qty); ?></td>
                <?php if($account->invoice_item_taxes): ?>
                    <td><?php echo e($item->tax_name1); ?></td>
                    <td><?php echo e($item->tax_rate1); ?></td>
                    <?php if($account->enable_second_tax_rate): ?>
                        <td><?php echo e($item->tax_name2); ?></td>
                        <td><?php echo e($item->tax_rate2); ?></td>
                    <?php endif; ?>
                <?php endif; ?>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/ehostco1/admin.ehost.co.zw/resources/views/export/invoices.blade.php ENDPATH**/ ?>