<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudBuild;

class PullRequestFilter extends \Google\Model
{
  /**
   * @var string
   */
  public $branch;
  /**
   * @var string
   */
  public $commentControl;
  /**
   * @var bool
   */
  public $invertRegex;

  /**
   * @param string
   */
  public function setBranch($branch)
  {
    $this->branch = $branch;
  }
  /**
   * @return string
   */
  public function getBranch()
  {
    return $this->branch;
  }
  /**
   * @param string
   */
  public function setCommentControl($commentControl)
  {
    $this->commentControl = $commentControl;
  }
  /**
   * @return string
   */
  public function getCommentControl()
  {
    return $this->commentControl;
  }
  /**
   * @param bool
   */
  public function setInvertRegex($invertRegex)
  {
    $this->invertRegex = $invertRegex;
  }
  /**
   * @return bool
   */
  public function getInvertRegex()
  {
    return $this->invertRegex;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PullRequestFilter::class, 'Google_Service_CloudBuild_PullRequestFilter');
