<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Forwarding Rule resource.
 * Forwarding rule resources in GCP can be either regional or global in scope:
 * * [Global](/compute/docs/reference/rest/{$api_version}/globalForwardingRules) * [Regional](https://cloud.google.com/compute/docs/reference/rest/{$api_version}/forwardingRules)
 * A forwarding rule and its corresponding IP address represent the frontend configuration of a Google Cloud Platform load balancer. Forwarding rules can also reference target instances and Cloud VPN Classic gateways (targetVpnGateway).
 * For more information, read Forwarding rule concepts and Using protocol forwarding.
 * (== resource_for {$api_version}.forwardingRules ==) (== resource_for {$api_version}.globalForwardingRules ==) (== resource_for {$api_version}.regionForwardingRules ==)
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.ForwardingRule</code>
 */
class ForwardingRule extends \Google\Protobuf\Internal\Message
{
    /**
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
     * When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
     *
     * Generated from protobuf field <code>bool all_ports = 176740340;</code>
     */
    private $all_ports = false;
    /**
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     *
     * Generated from protobuf field <code>bool allow_global_access = 230974218;</code>
     */
    private $allow_global_access = false;
    /**
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     *
     * Generated from protobuf field <code>string backend_service = 38510602;</code>
     */
    private $backend_service = '';
    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     */
    private $creation_timestamp = '';
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     */
    private $description = '';
    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
     * To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     */
    private $fingerprint = '';
    /**
     * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
     * If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
     * * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:
     * - projects/project_id/regions/region/addresses/address-name
     * - regions/region/addresses/address-name
     * - global/addresses/address-name
     * - address-name
     * The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
     *
     * Generated from protobuf field <code>string i_p_address = 254156495;</code>
     */
    private $i_p_address = '';
    /**
     * The IP protocol to which this rule applies.
     * For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
     * The valid IP protocols are different for different load balancing products:
     * - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
     * - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
     * - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
     * - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
     * - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.IPProtocol i_p_protocol = 55338781;</code>
     */
    private $i_p_protocol = 0;
    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     */
    private $id = '';
    /**
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.IpVersion ip_version = 26524096;</code>
     */
    private $ip_version = 0;
    /**
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     *
     * Generated from protobuf field <code>bool is_mirroring_collector = 119255164;</code>
     */
    private $is_mirroring_collector = false;
    /**
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     */
    private $kind = '';
    /**
     * Specifies the forwarding rule type.
     * - EXTERNAL is used for:
     * - Classic Cloud VPN gateways
     * - Protocol forwarding to VMs from an external IP address
     * - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
     * - INTERNAL is used for:
     * - Protocol forwarding to VMs from an internal IP address
     * - Internal TCP/UDP Load Balancing
     * - INTERNAL_MANAGED is used for:
     * - Internal HTTP(S) Load Balancing
     * - INTERNAL_SELF_MANAGED is used for:
     * - Traffic Director
     * For more information about forwarding rules, refer to Forwarding rule concepts.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.LoadBalancingScheme load_balancing_scheme = 95454788;</code>
     */
    private $load_balancing_scheme = 0;
    /**
     * Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
     * For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
     * metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
     * metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 196290283;</code>
     */
    private $metadata_filters;
    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * This field is not used for external load balancing.
     * For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     *
     * Generated from protobuf field <code>string network = 232872494;</code>
     */
    private $network = '';
    /**
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
     * For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
     * If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.NetworkTier network_tier = 248962387;</code>
     */
    private $network_tier = 0;
    /**
     * This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
     * Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
     * Some types of forwarding target have constraints on the acceptable ports:
     * - TargetHttpProxy: 80, 8080
     * - TargetHttpsProxy: 443
     * - TargetGrpcProxy: no constraints
     * - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * - TargetVpnGateway: 500, 4500
     *
     * Generated from protobuf field <code>string port_range = 217518079;</code>
     */
    private $port_range = '';
    /**
     * The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
     * You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
     * You can specify a list of up to five ports, which can be non-contiguous.
     * For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
     * For more information, see [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications).
     *
     * Generated from protobuf field <code>repeated string ports = 106854418;</code>
     */
    private $ports;
    /**
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     */
    private $region = '';
    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     */
    private $self_link = '';
    /**
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
     * The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * This field is only used for internal load balancing.
     *
     * Generated from protobuf field <code>string service_label = 148573418;</code>
     */
    private $service_label = '';
    /**
     * [Output Only] The internal fully qualified service name for this Forwarding Rule.
     * This field is only used for internal load balancing.
     *
     * Generated from protobuf field <code>string service_name = 91444693;</code>
     */
    private $service_name = '';
    /**
     * This field is only used for internal load balancing.
     * For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
     * If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
     *
     * Generated from protobuf field <code>string subnetwork = 39392238;</code>
     */
    private $subnetwork = '';
    /**
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For more information, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle. Currently, the supported Google API bundles include:
     * - vpc-sc - GCP APIs that support VPC Service Controls. For more information about which APIs support VPC Service Controls, refer to VPC-SC supported products and limitations.
     * - all-apis - All GCP APIs. For more information about which APIs are supported with this bundle, refer to Private Google Access-specific domains and VIPs.
     *
     * Generated from protobuf field <code>string target = 192835985;</code>
     */
    private $target = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $all_ports
     *           This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
     *           When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
     *     @type bool $allow_global_access
     *           This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     *     @type string $backend_service
     *           Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     *     @type string $creation_timestamp
     *           [Output Only] Creation timestamp in RFC3339 text format.
     *     @type string $description
     *           An optional description of this resource. Provide this property when you create the resource.
     *     @type string $fingerprint
     *           Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
     *           To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     *     @type string $i_p_address
     *           IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
     *           If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
     *           * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:
     *           - projects/project_id/regions/region/addresses/address-name
     *           - regions/region/addresses/address-name
     *           - global/addresses/address-name
     *           - address-name
     *           The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     *           Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
     *           For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
     *     @type int $i_p_protocol
     *           The IP protocol to which this rule applies.
     *           For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
     *           The valid IP protocols are different for different load balancing products:
     *           - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
     *           - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
     *           - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
     *           - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
     *           - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
     *     @type string $id
     *           [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *     @type int $ip_version
     *           The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
     *     @type bool $is_mirroring_collector
     *           Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     *     @type string $kind
     *           [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     *     @type int $load_balancing_scheme
     *           Specifies the forwarding rule type.
     *           - EXTERNAL is used for:
     *           - Classic Cloud VPN gateways
     *           - Protocol forwarding to VMs from an external IP address
     *           - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
     *           - INTERNAL is used for:
     *           - Protocol forwarding to VMs from an internal IP address
     *           - Internal TCP/UDP Load Balancing
     *           - INTERNAL_MANAGED is used for:
     *           - Internal HTTP(S) Load Balancing
     *           - INTERNAL_SELF_MANAGED is used for:
     *           - Traffic Director
     *           For more information about forwarding rules, refer to Forwarding rule concepts.
     *     @type \Google\Cloud\Compute\V1\MetadataFilter[]|\Google\Protobuf\Internal\RepeatedField $metadata_filters
     *           Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
     *           For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
     *           metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
     *           metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *     @type string $name
     *           Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *     @type string $network
     *           This field is not used for external load balancing.
     *           For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
     *           For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     *     @type int $network_tier
     *           This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
     *           For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
     *           If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     *     @type string $port_range
     *           This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
     *           Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
     *           Some types of forwarding target have constraints on the acceptable ports:
     *           - TargetHttpProxy: 80, 8080
     *           - TargetHttpsProxy: 443
     *           - TargetGrpcProxy: no constraints
     *           - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     *           - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     *           - TargetVpnGateway: 500, 4500
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $ports
     *           The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
     *           You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
     *           You can specify a list of up to five ports, which can be non-contiguous.
     *           For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
     *           For more information, see [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications).
     *     @type string $region
     *           [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *     @type string $self_link
     *           [Output Only] Server-defined URL for the resource.
     *     @type string $service_label
     *           An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
     *           The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *           This field is only used for internal load balancing.
     *     @type string $service_name
     *           [Output Only] The internal fully qualified service name for this Forwarding Rule.
     *           This field is only used for internal load balancing.
     *     @type string $subnetwork
     *           This field is only used for internal load balancing.
     *           For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
     *           If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
     *     @type string $target
     *           The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For more information, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     *           For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle. Currently, the supported Google API bundles include:
     *           - vpc-sc - GCP APIs that support VPC Service Controls. For more information about which APIs support VPC Service Controls, refer to VPC-SC supported products and limitations.
     *           - all-apis - All GCP APIs. For more information about which APIs are supported with this bundle, refer to Private Google Access-specific domains and VIPs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
     * When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
     *
     * Generated from protobuf field <code>bool all_ports = 176740340;</code>
     * @return bool
     */
    public function getAllPorts()
    {
        return $this->all_ports;
    }

    /**
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. This field cannot be used with port or portRange fields.
     * When the load balancing scheme is INTERNAL and protocol is TCP/UDP, specify this field to allow packets addressed to any ports will be forwarded to the backends configured with this forwarding rule.
     *
     * Generated from protobuf field <code>bool all_ports = 176740340;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllPorts($var)
    {
        GPBUtil::checkBool($var);
        $this->all_ports = $var;

        return $this;
    }

    /**
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     *
     * Generated from protobuf field <code>bool allow_global_access = 230974218;</code>
     * @return bool
     */
    public function getAllowGlobalAccess()
    {
        return $this->allow_global_access;
    }

    /**
     * This field is used along with the backend_service field for internal load balancing or with the target field for internal TargetInstance. If the field is set to TRUE, clients can access ILB from all regions. Otherwise only allows access from clients in the same region as the internal load balancer.
     *
     * Generated from protobuf field <code>bool allow_global_access = 230974218;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowGlobalAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_global_access = $var;

        return $this;
    }

    /**
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     *
     * Generated from protobuf field <code>string backend_service = 38510602;</code>
     * @return string
     */
    public function getBackendService()
    {
        return $this->backend_service;
    }

    /**
     * Identifies the backend service to which the forwarding rule sends traffic. Required for Internal TCP/UDP Load Balancing and Network Load Balancing; must be omitted for all other load balancer types.
     *
     * Generated from protobuf field <code>string backend_service = 38510602;</code>
     * @param string $var
     * @return $this
     */
    public function setBackendService($var)
    {
        GPBUtil::checkString($var, True);
        $this->backend_service = $var;

        return $this;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @return string
     */
    public function getCreationTimestamp()
    {
        return $this->creation_timestamp;
    }

    /**
     * [Output Only] Creation timestamp in RFC3339 text format.
     *
     * Generated from protobuf field <code>string creation_timestamp = 30525366;</code>
     * @param string $var
     * @return $this
     */
    public function setCreationTimestamp($var)
    {
        GPBUtil::checkString($var, True);
        $this->creation_timestamp = $var;

        return $this;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Generated from protobuf field <code>string description = 154502140;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
     * To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     * @return string
     */
    public function getFingerprint()
    {
        return $this->fingerprint;
    }

    /**
     * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a ForwardingRule. Include the fingerprint in patch request to ensure that you do not overwrite changes that were applied from another concurrent request.
     * To see the latest fingerprint, make a get() request to retrieve a ForwardingRule.
     *
     * Generated from protobuf field <code>string fingerprint = 234678500;</code>
     * @param string $var
     * @return $this
     */
    public function setFingerprint($var)
    {
        GPBUtil::checkString($var, True);
        $this->fingerprint = $var;

        return $this;
    }

    /**
     * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
     * If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
     * * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:
     * - projects/project_id/regions/region/addresses/address-name
     * - regions/region/addresses/address-name
     * - global/addresses/address-name
     * - address-name
     * The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
     *
     * Generated from protobuf field <code>string i_p_address = 254156495;</code>
     * @return string
     */
    public function getIPAddress()
    {
        return $this->i_p_address;
    }

    /**
     * IP address that this forwarding rule serves. When a client sends traffic to this IP address, the forwarding rule directs the traffic to the target that you specify in the forwarding rule.
     * If you don't specify a reserved IP address, an ephemeral IP address is assigned. Methods for specifying an IP address:
     * * IPv4 dotted decimal, as in `100.1.2.3` * Full URL, as in https://www.googleapis.com/compute/v1/projects/project_id/regions/region/addresses/address-name * Partial URL or by name, as in:
     * - projects/project_id/regions/region/addresses/address-name
     * - regions/region/addresses/address-name
     * - global/addresses/address-name
     * - address-name
     * The loadBalancingScheme and the forwarding rule's target determine the type of IP address that you can use. For detailed information, refer to [IP address specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * Must be set to `0.0.0.0` when the target is targetGrpcProxy that has validateForProxyless field set to true.
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, IP address must be provided.
     *
     * Generated from protobuf field <code>string i_p_address = 254156495;</code>
     * @param string $var
     * @return $this
     */
    public function setIPAddress($var)
    {
        GPBUtil::checkString($var, True);
        $this->i_p_address = $var;

        return $this;
    }

    /**
     * The IP protocol to which this rule applies.
     * For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
     * The valid IP protocols are different for different load balancing products:
     * - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
     * - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
     * - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
     * - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
     * - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.IPProtocol i_p_protocol = 55338781;</code>
     * @return int
     */
    public function getIPProtocol()
    {
        return $this->i_p_protocol;
    }

    /**
     * The IP protocol to which this rule applies.
     * For protocol forwarding, valid options are TCP, UDP, ESP, AH, SCTP and ICMP.
     * The valid IP protocols are different for different load balancing products:
     * - Internal TCP/UDP Load Balancing: The load balancing scheme is INTERNAL, and one of TCP, UDP or ALL is valid.
     * - Traffic Director: The load balancing scheme is INTERNAL_SELF_MANAGED, and only TCP is valid.
     * - Internal HTTP(S) Load Balancing: The load balancing scheme is INTERNAL_MANAGED, and only TCP is valid.
     * - HTTP(S), SSL Proxy, and TCP Proxy Load Balancing: The load balancing scheme is EXTERNAL and only TCP is valid.
     * - Network Load Balancing: The load balancing scheme is EXTERNAL, and one of TCP or UDP is valid.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.IPProtocol i_p_protocol = 55338781;</code>
     * @param int $var
     * @return $this
     */
    public function setIPProtocol($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\ForwardingRule\IPProtocol::class);
        $this->i_p_protocol = $var;

        return $this;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
     *
     * Generated from protobuf field <code>string id = 3355;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.IpVersion ip_version = 26524096;</code>
     * @return int
     */
    public function getIpVersion()
    {
        return $this->ip_version;
    }

    /**
     * The IP Version that will be used by this forwarding rule. Valid options are IPV4 or IPV6. This can only be specified for an external global forwarding rule.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.IpVersion ip_version = 26524096;</code>
     * @param int $var
     * @return $this
     */
    public function setIpVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\ForwardingRule\IpVersion::class);
        $this->ip_version = $var;

        return $this;
    }

    /**
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     *
     * Generated from protobuf field <code>bool is_mirroring_collector = 119255164;</code>
     * @return bool
     */
    public function getIsMirroringCollector()
    {
        return $this->is_mirroring_collector;
    }

    /**
     * Indicates whether or not this load balancer can be used as a collector for packet mirroring. To prevent mirroring loops, instances behind this load balancer will not have their traffic mirrored even if a PacketMirroring rule applies to them. This can only be set to true for load balancers that have their loadBalancingScheme set to INTERNAL.
     *
     * Generated from protobuf field <code>bool is_mirroring_collector = 119255164;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsMirroringCollector($var)
    {
        GPBUtil::checkBool($var);
        $this->is_mirroring_collector = $var;

        return $this;
    }

    /**
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @return string
     */
    public function getKind()
    {
        return $this->kind;
    }

    /**
     * [Output Only] Type of the resource. Always compute#forwardingRule for Forwarding Rule resources.
     *
     * Generated from protobuf field <code>string kind = 3292052;</code>
     * @param string $var
     * @return $this
     */
    public function setKind($var)
    {
        GPBUtil::checkString($var, True);
        $this->kind = $var;

        return $this;
    }

    /**
     * Specifies the forwarding rule type.
     * - EXTERNAL is used for:
     * - Classic Cloud VPN gateways
     * - Protocol forwarding to VMs from an external IP address
     * - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
     * - INTERNAL is used for:
     * - Protocol forwarding to VMs from an internal IP address
     * - Internal TCP/UDP Load Balancing
     * - INTERNAL_MANAGED is used for:
     * - Internal HTTP(S) Load Balancing
     * - INTERNAL_SELF_MANAGED is used for:
     * - Traffic Director
     * For more information about forwarding rules, refer to Forwarding rule concepts.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.LoadBalancingScheme load_balancing_scheme = 95454788;</code>
     * @return int
     */
    public function getLoadBalancingScheme()
    {
        return $this->load_balancing_scheme;
    }

    /**
     * Specifies the forwarding rule type.
     * - EXTERNAL is used for:
     * - Classic Cloud VPN gateways
     * - Protocol forwarding to VMs from an external IP address
     * - HTTP(S), SSL Proxy, TCP Proxy, and Network Load Balancing
     * - INTERNAL is used for:
     * - Protocol forwarding to VMs from an internal IP address
     * - Internal TCP/UDP Load Balancing
     * - INTERNAL_MANAGED is used for:
     * - Internal HTTP(S) Load Balancing
     * - INTERNAL_SELF_MANAGED is used for:
     * - Traffic Director
     * For more information about forwarding rules, refer to Forwarding rule concepts.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.LoadBalancingScheme load_balancing_scheme = 95454788;</code>
     * @param int $var
     * @return $this
     */
    public function setLoadBalancingScheme($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\ForwardingRule\LoadBalancingScheme::class);
        $this->load_balancing_scheme = $var;

        return $this;
    }

    /**
     * Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
     * For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
     * metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
     * metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 196290283;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMetadataFilters()
    {
        return $this->metadata_filters;
    }

    /**
     * Opaque filter criteria used by Loadbalancer to restrict routing configuration to a limited set of xDS compliant clients. In their xDS requests to Loadbalancer, xDS clients present node metadata. When there is a match, the relevant configuration is made available to those proxies. Otherwise, all the resources (e.g. TargetHttpProxy, UrlMap) referenced by the ForwardingRule will not be visible to those proxies.
     * For each metadataFilter in this list, if its filterMatchCriteria is set to MATCH_ANY, at least one of the filterLabels must match the corresponding label provided in the metadata. If its filterMatchCriteria is set to MATCH_ALL, then all of its filterLabels must match with corresponding labels provided in the metadata. If multiple metadataFilters are specified, all of them need to be satisfied in order to be considered a match.
     * metadataFilters specified here will be applifed before those specified in the UrlMap that this ForwardingRule references.
     * metadataFilters only applies to Loadbalancers that have their loadBalancingScheme set to INTERNAL_SELF_MANAGED.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.MetadataFilter metadata_filters = 196290283;</code>
     * @param \Google\Cloud\Compute\V1\MetadataFilter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMetadataFilters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\MetadataFilter::class);
        $this->metadata_filters = $arr;

        return $this;
    }

    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Name of the resource; provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * This field is not used for external load balancing.
     * For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     *
     * Generated from protobuf field <code>string network = 232872494;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * This field is not used for external load balancing.
     * For Internal TCP/UDP Load Balancing, this field identifies the network that the load balanced IP should belong to for this Forwarding Rule. If this field is not specified, the default network will be used.
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, a network must be provided.
     *
     * Generated from protobuf field <code>string network = 232872494;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
     * For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
     * If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.NetworkTier network_tier = 248962387;</code>
     * @return int
     */
    public function getNetworkTier()
    {
        return $this->network_tier;
    }

    /**
     * This signifies the networking tier used for configuring this load balancer and can only take the following values: PREMIUM, STANDARD.
     * For regional ForwardingRule, the valid values are PREMIUM and STANDARD. For GlobalForwardingRule, the valid value is PREMIUM.
     * If this field is not specified, it is assumed to be PREMIUM. If IPAddress is specified, this value must be equal to the networkTier of the Address.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.ForwardingRule.NetworkTier network_tier = 248962387;</code>
     * @param int $var
     * @return $this
     */
    public function setNetworkTier($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\ForwardingRule\NetworkTier::class);
        $this->network_tier = $var;

        return $this;
    }

    /**
     * This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
     * Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
     * Some types of forwarding target have constraints on the acceptable ports:
     * - TargetHttpProxy: 80, 8080
     * - TargetHttpsProxy: 443
     * - TargetGrpcProxy: no constraints
     * - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * - TargetVpnGateway: 500, 4500
     *
     * Generated from protobuf field <code>string port_range = 217518079;</code>
     * @return string
     */
    public function getPortRange()
    {
        return $this->port_range;
    }

    /**
     * This field can be used only if: * Load balancing scheme is one of EXTERNAL,  INTERNAL_SELF_MANAGED or INTERNAL_MANAGED, and * IPProtocol is one of TCP, UDP, or SCTP.
     * Packets addressed to ports in the specified range will be forwarded to target or  backend_service. You can only use one of ports, port_range, or allPorts. The three are mutually exclusive. Forwarding rules with the same [IPAddress, IPProtocol] pair must have disjoint port ranges.
     * Some types of forwarding target have constraints on the acceptable ports:
     * - TargetHttpProxy: 80, 8080
     * - TargetHttpsProxy: 443
     * - TargetGrpcProxy: no constraints
     * - TargetTcpProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * - TargetSslProxy: 25, 43, 110, 143, 195, 443, 465, 587, 700, 993, 995, 1688, 1883, 5222
     * - TargetVpnGateway: 500, 4500
     *
     * Generated from protobuf field <code>string port_range = 217518079;</code>
     * @param string $var
     * @return $this
     */
    public function setPortRange($var)
    {
        GPBUtil::checkString($var, True);
        $this->port_range = $var;

        return $this;
    }

    /**
     * The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
     * You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
     * You can specify a list of up to five ports, which can be non-contiguous.
     * For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
     * For more information, see [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications).
     *
     * Generated from protobuf field <code>repeated string ports = 106854418;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPorts()
    {
        return $this->ports;
    }

    /**
     * The ports field is only supported when the forwarding rule references a backend_service directly. Supported load balancing products are Internal TCP/UDP Load Balancing and Network Load Balancing. Only packets addressed to the specified list of ports are forwarded to backends.
     * You can only use one of ports and port_range, or allPorts. The three are mutually exclusive.
     * You can specify a list of up to five ports, which can be non-contiguous.
     * For Internal TCP/UDP Load Balancing, if you specify allPorts, you should not specify ports.
     * For more information, see [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#port_specifications).
     *
     * Generated from protobuf field <code>repeated string ports = 106854418;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPorts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ports = $arr;

        return $this;
    }

    /**
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @return string
     */
    public function getRegion()
    {
        return $this->region;
    }

    /**
     * [Output Only] URL of the region where the regional forwarding rule resides. This field is not applicable to global forwarding rules. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
     *
     * Generated from protobuf field <code>string region = 138946292;</code>
     * @param string $var
     * @return $this
     */
    public function setRegion($var)
    {
        GPBUtil::checkString($var, True);
        $this->region = $var;

        return $this;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * [Output Only] Server-defined URL for the resource.
     *
     * Generated from protobuf field <code>string self_link = 187779341;</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
     * The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * This field is only used for internal load balancing.
     *
     * Generated from protobuf field <code>string service_label = 148573418;</code>
     * @return string
     */
    public function getServiceLabel()
    {
        return $this->service_label;
    }

    /**
     * An optional prefix to the service name for this Forwarding Rule. If specified, the prefix is the first label of the fully qualified service name.
     * The label must be 1-63 characters long, and comply with RFC1035. Specifically, the label must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * This field is only used for internal load balancing.
     *
     * Generated from protobuf field <code>string service_label = 148573418;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceLabel($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_label = $var;

        return $this;
    }

    /**
     * [Output Only] The internal fully qualified service name for this Forwarding Rule.
     * This field is only used for internal load balancing.
     *
     * Generated from protobuf field <code>string service_name = 91444693;</code>
     * @return string
     */
    public function getServiceName()
    {
        return $this->service_name;
    }

    /**
     * [Output Only] The internal fully qualified service name for this Forwarding Rule.
     * This field is only used for internal load balancing.
     *
     * Generated from protobuf field <code>string service_name = 91444693;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceName($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_name = $var;

        return $this;
    }

    /**
     * This field is only used for internal load balancing.
     * For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
     * If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
     *
     * Generated from protobuf field <code>string subnetwork = 39392238;</code>
     * @return string
     */
    public function getSubnetwork()
    {
        return $this->subnetwork;
    }

    /**
     * This field is only used for internal load balancing.
     * For internal load balancing, this field identifies the subnetwork that the load balanced IP should belong to for this Forwarding Rule.
     * If the network specified is in auto subnet mode, this field is optional. However, if the network is in custom subnet mode, a subnetwork must be specified.
     *
     * Generated from protobuf field <code>string subnetwork = 39392238;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnetwork = $var;

        return $this;
    }

    /**
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For more information, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle. Currently, the supported Google API bundles include:
     * - vpc-sc - GCP APIs that support VPC Service Controls. For more information about which APIs support VPC Service Controls, refer to VPC-SC supported products and limitations.
     * - all-apis - All GCP APIs. For more information about which APIs are supported with this bundle, refer to Private Google Access-specific domains and VIPs.
     *
     * Generated from protobuf field <code>string target = 192835985;</code>
     * @return string
     */
    public function getTarget()
    {
        return $this->target;
    }

    /**
     * The URL of the target resource to receive the matched traffic. For regional forwarding rules, this target must be in the same region as the forwarding rule. For global forwarding rules, this target must be a global load balancing resource. The forwarded traffic must be of a type appropriate to the target object. For more information, see the "Target" column in [Port specifications](https://cloud.google.com/load-balancing/docs/forwarding-rule-concepts#ip_address_specifications).
     * For Private Service Connect forwarding rules that forward traffic to Google APIs, provide the name of a supported Google API bundle. Currently, the supported Google API bundles include:
     * - vpc-sc - GCP APIs that support VPC Service Controls. For more information about which APIs support VPC Service Controls, refer to VPC-SC supported products and limitations.
     * - all-apis - All GCP APIs. For more information about which APIs are supported with this bundle, refer to Private Google Access-specific domains and VIPs.
     *
     * Generated from protobuf field <code>string target = 192835985;</code>
     * @param string $var
     * @return $this
     */
    public function setTarget($var)
    {
        GPBUtil::checkString($var, True);
        $this->target = $var;

        return $this;
    }

}

