<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A path-matching rule for a URL. If matched, will use the specified BackendService to handle the traffic arriving at this URL.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.PathRule</code>
 */
class PathRule extends \Google\Protobuf\Internal\Message
{
    /**
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     *
     * Generated from protobuf field <code>repeated string paths = 106438894;</code>
     */
    private $paths;
    /**
     * In response to a matching path, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If routeAction specifies any  weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any  weightedBackendServices.
     * Only one of routeAction or urlRedirect must be set.
     * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a pathRule's routeAction.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRouteAction route_action = 156128492;</code>
     */
    private $route_action = null;
    /**
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified.
     * Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     *
     * Generated from protobuf field <code>string service = 105105077;</code>
     */
    private $service = '';
    /**
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
     * If urlRedirect is specified, service or routeAction must not be set.
     * Not supported when the URL map is bound to target gRPC proxy.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRedirectAction url_redirect = 136712364;</code>
     */
    private $url_redirect = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $paths
     *           The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     *     @type \Google\Cloud\Compute\V1\HttpRouteAction $route_action
     *           In response to a matching path, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If routeAction specifies any  weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any  weightedBackendServices.
     *           Only one of routeAction or urlRedirect must be set.
     *           UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a pathRule's routeAction.
     *     @type string $service
     *           The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified.
     *           Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     *     @type \Google\Cloud\Compute\V1\HttpRedirectAction $url_redirect
     *           When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
     *           If urlRedirect is specified, service or routeAction must not be set.
     *           Not supported when the URL map is bound to target gRPC proxy.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     *
     * Generated from protobuf field <code>repeated string paths = 106438894;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPaths()
    {
        return $this->paths;
    }

    /**
     * The list of path patterns to match. Each must start with / and the only place a * is allowed is at the end following a /. The string fed to the path matcher does not include any text after the first ? or #, and those chars are not allowed here.
     *
     * Generated from protobuf field <code>repeated string paths = 106438894;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPaths($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->paths = $arr;

        return $this;
    }

    /**
     * In response to a matching path, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If routeAction specifies any  weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any  weightedBackendServices.
     * Only one of routeAction or urlRedirect must be set.
     * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a pathRule's routeAction.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRouteAction route_action = 156128492;</code>
     * @return \Google\Cloud\Compute\V1\HttpRouteAction
     */
    public function getRouteAction()
    {
        return isset($this->route_action) ? $this->route_action : null;
    }

    public function hasRouteAction()
    {
        return isset($this->route_action);
    }

    public function clearRouteAction()
    {
        unset($this->route_action);
    }

    /**
     * In response to a matching path, the load balancer performs advanced routing actions like URL rewrites, header transformations, etc. prior to forwarding the request to the selected backend. If routeAction specifies any  weightedBackendServices, service must not be set. Conversely if service is set, routeAction cannot contain any  weightedBackendServices.
     * Only one of routeAction or urlRedirect must be set.
     * UrlMaps for external HTTP(S) load balancers support only the urlRewrite action within a pathRule's routeAction.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRouteAction route_action = 156128492;</code>
     * @param \Google\Cloud\Compute\V1\HttpRouteAction $var
     * @return $this
     */
    public function setRouteAction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\HttpRouteAction::class);
        $this->route_action = $var;

        return $this;
    }

    /**
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified.
     * Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     *
     * Generated from protobuf field <code>string service = 105105077;</code>
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * The full or partial URL of the backend service resource to which traffic is directed if this rule is matched. If routeAction is additionally specified, advanced routing actions like URL Rewrites, etc. take effect prior to sending the request to the backend. However, if service is specified, routeAction cannot contain any weightedBackendService s. Conversely, if routeAction specifies any  weightedBackendServices, service must not be specified.
     * Only one of urlRedirect, service or routeAction.weightedBackendService must be set.
     *
     * Generated from protobuf field <code>string service = 105105077;</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
     * If urlRedirect is specified, service or routeAction must not be set.
     * Not supported when the URL map is bound to target gRPC proxy.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRedirectAction url_redirect = 136712364;</code>
     * @return \Google\Cloud\Compute\V1\HttpRedirectAction
     */
    public function getUrlRedirect()
    {
        return isset($this->url_redirect) ? $this->url_redirect : null;
    }

    public function hasUrlRedirect()
    {
        return isset($this->url_redirect);
    }

    public function clearUrlRedirect()
    {
        unset($this->url_redirect);
    }

    /**
     * When a path pattern is matched, the request is redirected to a URL specified by urlRedirect.
     * If urlRedirect is specified, service or routeAction must not be set.
     * Not supported when the URL map is bound to target gRPC proxy.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.HttpRedirectAction url_redirect = 136712364;</code>
     * @param \Google\Cloud\Compute\V1\HttpRedirectAction $var
     * @return $this
     */
    public function setUrlRedirect($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\HttpRedirectAction::class);
        $this->url_redirect = $var;

        return $this;
    }

}

