PHP PhantomJS
=============

PHP PhantomJS is a flexible PHP library to load pages through the PhantomJS 
headless browser and return the page response. It is handy for testing
websites that demand javascript support and also supports screen captures.

[Full Documentation](http://jonnnnyw.github.io/php-phantomjs/)

[![Total Downloads](https://poser.pugx.org/jonnyw/php-phantomjs/downloads.png)](https://packagist.org/packages/jonnyw/php-phantomjs) [![Latest Stable Version](https://poser.pugx.org/jonnyw/php-phantomjs/v/stable.png)](https://packagist.org/packages/jonnyw/php-phantomjs) [![Build Status](https://travis-ci.org/jonnnnyw/php-phantomjs.svg?branch=master)](https://travis-ci.org/jonnnnyw/php-phantomjs) [![Scrutinizer Quality Score](https://scrutinizer-ci.com/g/jonnnnyw/php-phantomjs/badges/quality-score.png?s=631d32fa1fbb9300eb84b9b52702c7ffeac046a1)](https://scrutinizer-ci.com/g/jonnnnyw/php-phantomjs/) [![Code Coverage](https://scrutinizer-ci.com/g/jonnnnyw/php-phantomjs/badges/coverage.png?s=893b5997da45448e32983b8568a39630b0b2d91b)](https://scrutinizer-ci.com/g/jonnnnyw/php-phantomjs/)

Feature List
---------------------

*  Load webpages through the PhantomJS headless browser
*  View detailed response data including page content, headers, status code etc.
*  Handle redirects
*  View javascript console errors
*  View detailed PhantomJS debug information
*  Save screen captures to local disk
*  Output web pages to PDF document
*  Set viewport size
*  Set fixed header and footer for PDF output
*  Define screen capture x, y, width and height parameters
*  Delay page rendering for a specified time
*  Delay page rendering until page resources are fully loaded
*  Execute PhantomJS with command line options
*  Easily build and run custom PhantomJS scripts