<?php
// This file was auto-generated from sdk-root/src/data/cloudtrail/2013-11-01/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2013-11-01', 'endpointPrefix' => 'cloudtrail', 'jsonVersion' => '1.1', 'protocol' => 'json', 'serviceAbbreviation' => 'CloudTrail', 'serviceFullName' => 'AWS CloudTrail', 'serviceId' => 'CloudTrail', 'signatureVersion' => 'v4', 'targetPrefix' => 'com.amazonaws.cloudtrail.v20131101.CloudTrail_20131101', 'uid' => 'cloudtrail-2013-11-01', ], 'operations' => [ 'AddTags' => [ 'name' => 'AddTags', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'AddTagsRequest', ], 'output' => [ 'shape' => 'AddTagsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'CloudTrailARNInvalidException', ], [ 'shape' => 'ResourceTypeNotSupportedException', ], [ 'shape' => 'TagsLimitExceededException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidTagParameterException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'CancelQuery' => [ 'name' => 'CancelQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CancelQueryRequest', ], 'output' => [ 'shape' => 'CancelQueryResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'InactiveQueryException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'QueryIdNotFoundException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'CreateEventDataStore' => [ 'name' => 'CreateEventDataStore', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateEventDataStoreRequest', ], 'output' => [ 'shape' => 'CreateEventDataStoreResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreAlreadyExistsException', ], [ 'shape' => 'EventDataStoreMaxLimitExceededException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidTagParameterException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'CloudTrailAccessNotEnabledException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'OrganizationsNotInUseException', ], [ 'shape' => 'OrganizationNotInAllFeaturesModeException', ], ], ], 'CreateTrail' => [ 'name' => 'CreateTrail', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'CreateTrailRequest', ], 'output' => [ 'shape' => 'CreateTrailResponse', ], 'errors' => [ [ 'shape' => 'MaximumNumberOfTrailsExceededException', ], [ 'shape' => 'TrailAlreadyExistsException', ], [ 'shape' => 'S3BucketDoesNotExistException', ], [ 'shape' => 'InsufficientS3BucketPolicyException', ], [ 'shape' => 'InsufficientSnsTopicPolicyException', ], [ 'shape' => 'InsufficientEncryptionPolicyException', ], [ 'shape' => 'InvalidS3BucketNameException', ], [ 'shape' => 'InvalidS3PrefixException', ], [ 'shape' => 'InvalidSnsTopicNameException', ], [ 'shape' => 'InvalidKmsKeyIdException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'TrailNotProvidedException', ], [ 'shape' => 'InvalidParameterCombinationException', ], [ 'shape' => 'KmsKeyNotFoundException', ], [ 'shape' => 'KmsKeyDisabledException', ], [ 'shape' => 'KmsException', ], [ 'shape' => 'InvalidCloudWatchLogsLogGroupArnException', ], [ 'shape' => 'InvalidCloudWatchLogsRoleArnException', ], [ 'shape' => 'CloudWatchLogsDeliveryUnavailableException', ], [ 'shape' => 'InvalidTagParameterException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'CloudTrailAccessNotEnabledException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'OrganizationsNotInUseException', ], [ 'shape' => 'OrganizationNotInAllFeaturesModeException', ], [ 'shape' => 'CloudTrailInvalidClientTokenIdException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DeleteEventDataStore' => [ 'name' => 'DeleteEventDataStore', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteEventDataStoreRequest', ], 'output' => [ 'shape' => 'DeleteEventDataStoreResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'EventDataStoreTerminationProtectedException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], ], ], 'DeleteTrail' => [ 'name' => 'DeleteTrail', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DeleteTrailRequest', ], 'output' => [ 'shape' => 'DeleteTrailResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidHomeRegionException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], [ 'shape' => 'ConflictException', ], ], 'idempotent' => true, ], 'DescribeQuery' => [ 'name' => 'DescribeQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeQueryRequest', ], 'output' => [ 'shape' => 'DescribeQueryResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'QueryIdNotFoundException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], ], 'idempotent' => true, ], 'DescribeTrails' => [ 'name' => 'DescribeTrails', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'DescribeTrailsRequest', ], 'output' => [ 'shape' => 'DescribeTrailsResponse', ], 'errors' => [ [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'InvalidTrailNameException', ], ], 'idempotent' => true, ], 'GetEventDataStore' => [ 'name' => 'GetEventDataStore', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetEventDataStoreRequest', ], 'output' => [ 'shape' => 'GetEventDataStoreResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], ], 'idempotent' => true, ], 'GetEventSelectors' => [ 'name' => 'GetEventSelectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetEventSelectorsRequest', ], 'output' => [ 'shape' => 'GetEventSelectorsResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], ], 'idempotent' => true, ], 'GetInsightSelectors' => [ 'name' => 'GetInsightSelectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetInsightSelectorsRequest', ], 'output' => [ 'shape' => 'GetInsightSelectorsResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'InsightNotEnabledException', ], ], 'idempotent' => true, ], 'GetQueryResults' => [ 'name' => 'GetQueryResults', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetQueryResultsRequest', ], 'output' => [ 'shape' => 'GetQueryResultsResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'InvalidMaxResultsException', ], [ 'shape' => 'InvalidNextTokenException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'QueryIdNotFoundException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], ], ], 'GetTrail' => [ 'name' => 'GetTrail', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetTrailRequest', ], 'output' => [ 'shape' => 'GetTrailResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], ], 'idempotent' => true, ], 'GetTrailStatus' => [ 'name' => 'GetTrailStatus', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'GetTrailStatusRequest', ], 'output' => [ 'shape' => 'GetTrailStatusResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], ], 'idempotent' => true, ], 'ListEventDataStores' => [ 'name' => 'ListEventDataStores', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListEventDataStoresRequest', ], 'output' => [ 'shape' => 'ListEventDataStoresResponse', ], 'errors' => [ [ 'shape' => 'InvalidMaxResultsException', ], [ 'shape' => 'InvalidNextTokenException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], ], 'idempotent' => true, ], 'ListPublicKeys' => [ 'name' => 'ListPublicKeys', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListPublicKeysRequest', ], 'output' => [ 'shape' => 'ListPublicKeysResponse', ], 'errors' => [ [ 'shape' => 'InvalidTimeRangeException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'InvalidTokenException', ], ], 'idempotent' => true, ], 'ListQueries' => [ 'name' => 'ListQueries', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListQueriesRequest', ], 'output' => [ 'shape' => 'ListQueriesResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'InvalidDateRangeException', ], [ 'shape' => 'InvalidMaxResultsException', ], [ 'shape' => 'InvalidNextTokenException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidQueryStatusException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], ], 'idempotent' => true, ], 'ListTags' => [ 'name' => 'ListTags', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTagsRequest', ], 'output' => [ 'shape' => 'ListTagsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'CloudTrailARNInvalidException', ], [ 'shape' => 'ResourceTypeNotSupportedException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'InvalidTokenException', ], ], 'idempotent' => true, ], 'ListTrails' => [ 'name' => 'ListTrails', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'ListTrailsRequest', ], 'output' => [ 'shape' => 'ListTrailsResponse', ], 'errors' => [ [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], ], 'idempotent' => true, ], 'LookupEvents' => [ 'name' => 'LookupEvents', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'LookupEventsRequest', ], 'output' => [ 'shape' => 'LookupEventsResponse', ], 'errors' => [ [ 'shape' => 'InvalidLookupAttributesException', ], [ 'shape' => 'InvalidTimeRangeException', ], [ 'shape' => 'InvalidMaxResultsException', ], [ 'shape' => 'InvalidNextTokenException', ], [ 'shape' => 'InvalidEventCategoryException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], ], 'idempotent' => true, ], 'PutEventSelectors' => [ 'name' => 'PutEventSelectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'PutEventSelectorsRequest', ], 'output' => [ 'shape' => 'PutEventSelectorsResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidHomeRegionException', ], [ 'shape' => 'InvalidEventSelectorsException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], ], 'idempotent' => true, ], 'PutInsightSelectors' => [ 'name' => 'PutInsightSelectors', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'PutInsightSelectorsRequest', ], 'output' => [ 'shape' => 'PutInsightSelectorsResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidHomeRegionException', ], [ 'shape' => 'InvalidInsightSelectorsException', ], [ 'shape' => 'InsufficientS3BucketPolicyException', ], [ 'shape' => 'InsufficientEncryptionPolicyException', ], [ 'shape' => 'S3BucketDoesNotExistException', ], [ 'shape' => 'KmsException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], ], 'idempotent' => true, ], 'RemoveTags' => [ 'name' => 'RemoveTags', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RemoveTagsRequest', ], 'output' => [ 'shape' => 'RemoveTagsResponse', ], 'errors' => [ [ 'shape' => 'ResourceNotFoundException', ], [ 'shape' => 'CloudTrailARNInvalidException', ], [ 'shape' => 'ResourceTypeNotSupportedException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidTagParameterException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], ], 'idempotent' => true, ], 'RestoreEventDataStore' => [ 'name' => 'RestoreEventDataStore', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'RestoreEventDataStoreRequest', ], 'output' => [ 'shape' => 'RestoreEventDataStoreResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'EventDataStoreMaxLimitExceededException', ], [ 'shape' => 'InvalidEventDataStoreStatusException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'CloudTrailAccessNotEnabledException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], [ 'shape' => 'OrganizationsNotInUseException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'OrganizationNotInAllFeaturesModeException', ], ], ], 'StartLogging' => [ 'name' => 'StartLogging', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartLoggingRequest', ], 'output' => [ 'shape' => 'StartLoggingResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidHomeRegionException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], ], 'idempotent' => true, ], 'StartQuery' => [ 'name' => 'StartQuery', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StartQueryRequest', ], 'output' => [ 'shape' => 'StartQueryResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'InvalidQueryStatementException', ], [ 'shape' => 'MaxConcurrentQueriesException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], ], 'idempotent' => true, ], 'StopLogging' => [ 'name' => 'StopLogging', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'StopLoggingRequest', ], 'output' => [ 'shape' => 'StopLoggingResponse', ], 'errors' => [ [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'InvalidHomeRegionException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], ], 'idempotent' => true, ], 'UpdateEventDataStore' => [ 'name' => 'UpdateEventDataStore', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateEventDataStoreRequest', ], 'output' => [ 'shape' => 'UpdateEventDataStoreResponse', ], 'errors' => [ [ 'shape' => 'EventDataStoreARNInvalidException', ], [ 'shape' => 'EventDataStoreNotFoundException', ], [ 'shape' => 'InactiveEventDataStoreException', ], [ 'shape' => 'InvalidParameterException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'CloudTrailAccessNotEnabledException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], [ 'shape' => 'OrganizationsNotInUseException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'OrganizationNotInAllFeaturesModeException', ], ], 'idempotent' => true, ], 'UpdateTrail' => [ 'name' => 'UpdateTrail', 'http' => [ 'method' => 'POST', 'requestUri' => '/', ], 'input' => [ 'shape' => 'UpdateTrailRequest', ], 'output' => [ 'shape' => 'UpdateTrailResponse', ], 'errors' => [ [ 'shape' => 'S3BucketDoesNotExistException', ], [ 'shape' => 'InsufficientS3BucketPolicyException', ], [ 'shape' => 'InsufficientSnsTopicPolicyException', ], [ 'shape' => 'InsufficientEncryptionPolicyException', ], [ 'shape' => 'TrailNotFoundException', ], [ 'shape' => 'InvalidS3BucketNameException', ], [ 'shape' => 'InvalidS3PrefixException', ], [ 'shape' => 'InvalidSnsTopicNameException', ], [ 'shape' => 'InvalidKmsKeyIdException', ], [ 'shape' => 'InvalidTrailNameException', ], [ 'shape' => 'TrailNotProvidedException', ], [ 'shape' => 'InvalidEventSelectorsException', ], [ 'shape' => 'InvalidParameterCombinationException', ], [ 'shape' => 'InvalidHomeRegionException', ], [ 'shape' => 'KmsKeyNotFoundException', ], [ 'shape' => 'KmsKeyDisabledException', ], [ 'shape' => 'KmsException', ], [ 'shape' => 'InvalidCloudWatchLogsLogGroupArnException', ], [ 'shape' => 'InvalidCloudWatchLogsRoleArnException', ], [ 'shape' => 'CloudWatchLogsDeliveryUnavailableException', ], [ 'shape' => 'UnsupportedOperationException', ], [ 'shape' => 'OperationNotPermittedException', ], [ 'shape' => 'CloudTrailAccessNotEnabledException', ], [ 'shape' => 'InsufficientDependencyServiceAccessPermissionException', ], [ 'shape' => 'OrganizationsNotInUseException', ], [ 'shape' => 'NotOrganizationMasterAccountException', ], [ 'shape' => 'OrganizationNotInAllFeaturesModeException', ], [ 'shape' => 'CloudTrailInvalidClientTokenIdException', ], ], 'idempotent' => true, ], ], 'shapes' => [ 'AddTagsRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceId', 'TagsList', ], 'members' => [ 'ResourceId' => [ 'shape' => 'String', ], 'TagsList' => [ 'shape' => 'TagsList', ], ], ], 'AddTagsResponse' => [ 'type' => 'structure', 'members' => [], ], 'AdvancedEventSelector' => [ 'type' => 'structure', 'required' => [ 'FieldSelectors', ], 'members' => [ 'Name' => [ 'shape' => 'SelectorName', ], 'FieldSelectors' => [ 'shape' => 'AdvancedFieldSelectors', ], ], ], 'AdvancedEventSelectors' => [ 'type' => 'list', 'member' => [ 'shape' => 'AdvancedEventSelector', ], ], 'AdvancedFieldSelector' => [ 'type' => 'structure', 'required' => [ 'Field', ], 'members' => [ 'Field' => [ 'shape' => 'SelectorField', ], 'Equals' => [ 'shape' => 'Operator', ], 'StartsWith' => [ 'shape' => 'Operator', ], 'EndsWith' => [ 'shape' => 'Operator', ], 'NotEquals' => [ 'shape' => 'Operator', ], 'NotStartsWith' => [ 'shape' => 'Operator', ], 'NotEndsWith' => [ 'shape' => 'Operator', ], ], ], 'AdvancedFieldSelectors' => [ 'type' => 'list', 'member' => [ 'shape' => 'AdvancedFieldSelector', ], 'min' => 1, ], 'Boolean' => [ 'type' => 'boolean', ], 'ByteBuffer' => [ 'type' => 'blob', ], 'CancelQueryRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', 'QueryId', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], 'QueryId' => [ 'shape' => 'UUID', ], ], ], 'CancelQueryResponse' => [ 'type' => 'structure', 'required' => [ 'QueryId', 'QueryStatus', ], 'members' => [ 'QueryId' => [ 'shape' => 'UUID', ], 'QueryStatus' => [ 'shape' => 'QueryStatus', ], ], ], 'CloudTrailARNInvalidException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'CloudTrailAccessNotEnabledException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'CloudTrailInvalidClientTokenIdException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'CloudWatchLogsDeliveryUnavailableException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'ConflictException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'CreateEventDataStoreRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'EventDataStoreName', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], 'TagsList' => [ 'shape' => 'TagsList', ], ], ], 'CreateEventDataStoreResponse' => [ 'type' => 'structure', 'members' => [ 'EventDataStoreArn' => [ 'shape' => 'EventDataStoreArn', ], 'Name' => [ 'shape' => 'EventDataStoreName', ], 'Status' => [ 'shape' => 'EventDataStoreStatus', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], 'TagsList' => [ 'shape' => 'TagsList', ], 'CreatedTimestamp' => [ 'shape' => 'Date', ], 'UpdatedTimestamp' => [ 'shape' => 'Date', ], ], ], 'CreateTrailRequest' => [ 'type' => 'structure', 'required' => [ 'Name', 'S3BucketName', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], 'S3BucketName' => [ 'shape' => 'String', ], 'S3KeyPrefix' => [ 'shape' => 'String', ], 'SnsTopicName' => [ 'shape' => 'String', ], 'IncludeGlobalServiceEvents' => [ 'shape' => 'Boolean', ], 'IsMultiRegionTrail' => [ 'shape' => 'Boolean', ], 'EnableLogFileValidation' => [ 'shape' => 'Boolean', ], 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'String', ], 'CloudWatchLogsRoleArn' => [ 'shape' => 'String', ], 'KmsKeyId' => [ 'shape' => 'String', ], 'IsOrganizationTrail' => [ 'shape' => 'Boolean', ], 'TagsList' => [ 'shape' => 'TagsList', ], ], ], 'CreateTrailResponse' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'String', ], 'S3BucketName' => [ 'shape' => 'String', ], 'S3KeyPrefix' => [ 'shape' => 'String', ], 'SnsTopicName' => [ 'shape' => 'String', 'deprecated' => true, ], 'SnsTopicARN' => [ 'shape' => 'String', ], 'IncludeGlobalServiceEvents' => [ 'shape' => 'Boolean', ], 'IsMultiRegionTrail' => [ 'shape' => 'Boolean', ], 'TrailARN' => [ 'shape' => 'String', ], 'LogFileValidationEnabled' => [ 'shape' => 'Boolean', ], 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'String', ], 'CloudWatchLogsRoleArn' => [ 'shape' => 'String', ], 'KmsKeyId' => [ 'shape' => 'String', ], 'IsOrganizationTrail' => [ 'shape' => 'Boolean', ], ], ], 'DataResource' => [ 'type' => 'structure', 'members' => [ 'Type' => [ 'shape' => 'String', ], 'Values' => [ 'shape' => 'DataResourceValues', ], ], ], 'DataResourceValues' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'DataResources' => [ 'type' => 'list', 'member' => [ 'shape' => 'DataResource', ], ], 'Date' => [ 'type' => 'timestamp', ], 'DeleteEventDataStoreRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], ], ], 'DeleteEventDataStoreResponse' => [ 'type' => 'structure', 'members' => [], ], 'DeleteTrailRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], ], ], 'DeleteTrailResponse' => [ 'type' => 'structure', 'members' => [], ], 'DescribeQueryRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', 'QueryId', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], 'QueryId' => [ 'shape' => 'UUID', ], ], ], 'DescribeQueryResponse' => [ 'type' => 'structure', 'members' => [ 'QueryId' => [ 'shape' => 'UUID', ], 'QueryString' => [ 'shape' => 'QueryStatement', ], 'QueryStatus' => [ 'shape' => 'QueryStatus', ], 'QueryStatistics' => [ 'shape' => 'QueryStatisticsForDescribeQuery', ], 'ErrorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'DescribeTrailsRequest' => [ 'type' => 'structure', 'members' => [ 'trailNameList' => [ 'shape' => 'TrailNameList', ], 'includeShadowTrails' => [ 'shape' => 'Boolean', ], ], ], 'DescribeTrailsResponse' => [ 'type' => 'structure', 'members' => [ 'trailList' => [ 'shape' => 'TrailList', ], ], ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 1000, 'min' => 4, 'pattern' => '.*', ], 'Event' => [ 'type' => 'structure', 'members' => [ 'EventId' => [ 'shape' => 'String', ], 'EventName' => [ 'shape' => 'String', ], 'ReadOnly' => [ 'shape' => 'String', ], 'AccessKeyId' => [ 'shape' => 'String', ], 'EventTime' => [ 'shape' => 'Date', ], 'EventSource' => [ 'shape' => 'String', ], 'Username' => [ 'shape' => 'String', ], 'Resources' => [ 'shape' => 'ResourceList', ], 'CloudTrailEvent' => [ 'shape' => 'String', ], ], ], 'EventCategory' => [ 'type' => 'string', 'enum' => [ 'insight', ], ], 'EventDataStore' => [ 'type' => 'structure', 'members' => [ 'EventDataStoreArn' => [ 'shape' => 'EventDataStoreArn', ], 'Name' => [ 'shape' => 'EventDataStoreName', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], 'Status' => [ 'shape' => 'EventDataStoreStatus', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'CreatedTimestamp' => [ 'shape' => 'Date', ], 'UpdatedTimestamp' => [ 'shape' => 'Date', ], ], ], 'EventDataStoreARNInvalidException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'EventDataStoreAlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'EventDataStoreArn' => [ 'type' => 'string', 'max' => 256, 'min' => 3, 'pattern' => '^[a-zA-Z0-9._/\\-:]+$', ], 'EventDataStoreMaxLimitExceededException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'EventDataStoreName' => [ 'type' => 'string', 'max' => 128, 'min' => 3, 'pattern' => '^[a-zA-Z0-9._\\-]+$', ], 'EventDataStoreNotFoundException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'EventDataStoreStatus' => [ 'type' => 'string', 'enum' => [ 'CREATED', 'ENABLED', 'PENDING_DELETION', ], ], 'EventDataStoreTerminationProtectedException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'EventDataStores' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventDataStore', ], ], 'EventSelector' => [ 'type' => 'structure', 'members' => [ 'ReadWriteType' => [ 'shape' => 'ReadWriteType', ], 'IncludeManagementEvents' => [ 'shape' => 'Boolean', ], 'DataResources' => [ 'shape' => 'DataResources', ], 'ExcludeManagementEventSources' => [ 'shape' => 'ExcludeManagementEventSources', ], ], ], 'EventSelectors' => [ 'type' => 'list', 'member' => [ 'shape' => 'EventSelector', ], ], 'EventsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Event', ], ], 'ExcludeManagementEventSources' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'GetEventDataStoreRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], ], ], 'GetEventDataStoreResponse' => [ 'type' => 'structure', 'members' => [ 'EventDataStoreArn' => [ 'shape' => 'EventDataStoreArn', ], 'Name' => [ 'shape' => 'EventDataStoreName', ], 'Status' => [ 'shape' => 'EventDataStoreStatus', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], 'CreatedTimestamp' => [ 'shape' => 'Date', ], 'UpdatedTimestamp' => [ 'shape' => 'Date', ], ], ], 'GetEventSelectorsRequest' => [ 'type' => 'structure', 'required' => [ 'TrailName', ], 'members' => [ 'TrailName' => [ 'shape' => 'String', ], ], ], 'GetEventSelectorsResponse' => [ 'type' => 'structure', 'members' => [ 'TrailARN' => [ 'shape' => 'String', ], 'EventSelectors' => [ 'shape' => 'EventSelectors', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], ], ], 'GetInsightSelectorsRequest' => [ 'type' => 'structure', 'required' => [ 'TrailName', ], 'members' => [ 'TrailName' => [ 'shape' => 'String', ], ], ], 'GetInsightSelectorsResponse' => [ 'type' => 'structure', 'members' => [ 'TrailARN' => [ 'shape' => 'String', ], 'InsightSelectors' => [ 'shape' => 'InsightSelectors', ], ], ], 'GetQueryResultsRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', 'QueryId', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], 'QueryId' => [ 'shape' => 'UUID', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], 'MaxQueryResults' => [ 'shape' => 'MaxQueryResults', ], ], ], 'GetQueryResultsResponse' => [ 'type' => 'structure', 'members' => [ 'QueryStatus' => [ 'shape' => 'QueryStatus', ], 'QueryStatistics' => [ 'shape' => 'QueryStatistics', ], 'QueryResultRows' => [ 'shape' => 'QueryResultRows', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], 'ErrorMessage' => [ 'shape' => 'ErrorMessage', ], ], ], 'GetTrailRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], ], ], 'GetTrailResponse' => [ 'type' => 'structure', 'members' => [ 'Trail' => [ 'shape' => 'Trail', ], ], ], 'GetTrailStatusRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], ], ], 'GetTrailStatusResponse' => [ 'type' => 'structure', 'members' => [ 'IsLogging' => [ 'shape' => 'Boolean', ], 'LatestDeliveryError' => [ 'shape' => 'String', ], 'LatestNotificationError' => [ 'shape' => 'String', ], 'LatestDeliveryTime' => [ 'shape' => 'Date', ], 'LatestNotificationTime' => [ 'shape' => 'Date', ], 'StartLoggingTime' => [ 'shape' => 'Date', ], 'StopLoggingTime' => [ 'shape' => 'Date', ], 'LatestCloudWatchLogsDeliveryError' => [ 'shape' => 'String', ], 'LatestCloudWatchLogsDeliveryTime' => [ 'shape' => 'Date', ], 'LatestDigestDeliveryTime' => [ 'shape' => 'Date', ], 'LatestDigestDeliveryError' => [ 'shape' => 'String', ], 'LatestDeliveryAttemptTime' => [ 'shape' => 'String', ], 'LatestNotificationAttemptTime' => [ 'shape' => 'String', ], 'LatestNotificationAttemptSucceeded' => [ 'shape' => 'String', ], 'LatestDeliveryAttemptSucceeded' => [ 'shape' => 'String', ], 'TimeLoggingStarted' => [ 'shape' => 'String', ], 'TimeLoggingStopped' => [ 'shape' => 'String', ], ], ], 'InactiveEventDataStoreException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InactiveQueryException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InsightNotEnabledException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InsightSelector' => [ 'type' => 'structure', 'members' => [ 'InsightType' => [ 'shape' => 'InsightType', ], ], ], 'InsightSelectors' => [ 'type' => 'list', 'member' => [ 'shape' => 'InsightSelector', ], ], 'InsightType' => [ 'type' => 'string', 'enum' => [ 'ApiCallRateInsight', 'ApiErrorRateInsight', ], ], 'InsufficientDependencyServiceAccessPermissionException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InsufficientEncryptionPolicyException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InsufficientS3BucketPolicyException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InsufficientSnsTopicPolicyException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'Integer' => [ 'type' => 'integer', ], 'InvalidCloudWatchLogsLogGroupArnException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidCloudWatchLogsRoleArnException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidDateRangeException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidEventCategoryException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidEventDataStoreStatusException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidEventSelectorsException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidHomeRegionException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidInsightSelectorsException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidKmsKeyIdException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidLookupAttributesException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidMaxResultsException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidNextTokenException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidParameterCombinationException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidParameterException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidQueryStatementException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidQueryStatusException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidS3BucketNameException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidS3PrefixException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidSnsTopicNameException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidTagParameterException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidTimeRangeException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidTokenException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'InvalidTrailNameException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'KmsException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'KmsKeyDisabledException' => [ 'type' => 'structure', 'members' => [], 'deprecated' => true, 'exception' => true, ], 'KmsKeyNotFoundException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'ListEventDataStoresMaxResultsCount' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'ListEventDataStoresRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'PaginationToken', ], 'MaxResults' => [ 'shape' => 'ListEventDataStoresMaxResultsCount', ], ], ], 'ListEventDataStoresResponse' => [ 'type' => 'structure', 'members' => [ 'EventDataStores' => [ 'shape' => 'EventDataStores', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListPublicKeysRequest' => [ 'type' => 'structure', 'members' => [ 'StartTime' => [ 'shape' => 'Date', ], 'EndTime' => [ 'shape' => 'Date', ], 'NextToken' => [ 'shape' => 'String', ], ], ], 'ListPublicKeysResponse' => [ 'type' => 'structure', 'members' => [ 'PublicKeyList' => [ 'shape' => 'PublicKeyList', ], 'NextToken' => [ 'shape' => 'String', ], ], ], 'ListQueriesMaxResultsCount' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'ListQueriesRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], 'MaxResults' => [ 'shape' => 'ListQueriesMaxResultsCount', ], 'StartTime' => [ 'shape' => 'Date', ], 'EndTime' => [ 'shape' => 'Date', ], 'QueryStatus' => [ 'shape' => 'QueryStatus', ], ], ], 'ListQueriesResponse' => [ 'type' => 'structure', 'members' => [ 'Queries' => [ 'shape' => 'Queries', ], 'NextToken' => [ 'shape' => 'PaginationToken', ], ], ], 'ListTagsRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceIdList', ], 'members' => [ 'ResourceIdList' => [ 'shape' => 'ResourceIdList', ], 'NextToken' => [ 'shape' => 'String', ], ], ], 'ListTagsResponse' => [ 'type' => 'structure', 'members' => [ 'ResourceTagList' => [ 'shape' => 'ResourceTagList', ], 'NextToken' => [ 'shape' => 'String', ], ], ], 'ListTrailsRequest' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'String', ], ], ], 'ListTrailsResponse' => [ 'type' => 'structure', 'members' => [ 'Trails' => [ 'shape' => 'Trails', ], 'NextToken' => [ 'shape' => 'String', ], ], ], 'Long' => [ 'type' => 'long', ], 'LookupAttribute' => [ 'type' => 'structure', 'required' => [ 'AttributeKey', 'AttributeValue', ], 'members' => [ 'AttributeKey' => [ 'shape' => 'LookupAttributeKey', ], 'AttributeValue' => [ 'shape' => 'String', ], ], ], 'LookupAttributeKey' => [ 'type' => 'string', 'enum' => [ 'EventId', 'EventName', 'ReadOnly', 'Username', 'ResourceType', 'ResourceName', 'EventSource', 'AccessKeyId', ], ], 'LookupAttributesList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LookupAttribute', ], ], 'LookupEventsRequest' => [ 'type' => 'structure', 'members' => [ 'LookupAttributes' => [ 'shape' => 'LookupAttributesList', ], 'StartTime' => [ 'shape' => 'Date', ], 'EndTime' => [ 'shape' => 'Date', ], 'EventCategory' => [ 'shape' => 'EventCategory', ], 'MaxResults' => [ 'shape' => 'MaxResults', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'LookupEventsResponse' => [ 'type' => 'structure', 'members' => [ 'Events' => [ 'shape' => 'EventsList', ], 'NextToken' => [ 'shape' => 'NextToken', ], ], ], 'MaxConcurrentQueriesException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'MaxQueryResults' => [ 'type' => 'integer', 'max' => 1000, 'min' => 1, ], 'MaxResults' => [ 'type' => 'integer', 'max' => 50, 'min' => 1, ], 'MaximumNumberOfTrailsExceededException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'NextToken' => [ 'type' => 'string', ], 'NotOrganizationMasterAccountException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'OperationNotPermittedException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'Operator' => [ 'type' => 'list', 'member' => [ 'shape' => 'OperatorValue', ], 'min' => 1, ], 'OperatorValue' => [ 'type' => 'string', 'max' => 2048, 'min' => 1, 'pattern' => '.+', ], 'OrganizationNotInAllFeaturesModeException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'OrganizationsNotInUseException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'PaginationToken' => [ 'type' => 'string', 'max' => 1000, 'min' => 4, 'pattern' => '.*', ], 'PublicKey' => [ 'type' => 'structure', 'members' => [ 'Value' => [ 'shape' => 'ByteBuffer', ], 'ValidityStartTime' => [ 'shape' => 'Date', ], 'ValidityEndTime' => [ 'shape' => 'Date', ], 'Fingerprint' => [ 'shape' => 'String', ], ], ], 'PublicKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'PublicKey', ], ], 'PutEventSelectorsRequest' => [ 'type' => 'structure', 'required' => [ 'TrailName', ], 'members' => [ 'TrailName' => [ 'shape' => 'String', ], 'EventSelectors' => [ 'shape' => 'EventSelectors', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], ], ], 'PutEventSelectorsResponse' => [ 'type' => 'structure', 'members' => [ 'TrailARN' => [ 'shape' => 'String', ], 'EventSelectors' => [ 'shape' => 'EventSelectors', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], ], ], 'PutInsightSelectorsRequest' => [ 'type' => 'structure', 'required' => [ 'TrailName', 'InsightSelectors', ], 'members' => [ 'TrailName' => [ 'shape' => 'String', ], 'InsightSelectors' => [ 'shape' => 'InsightSelectors', ], ], ], 'PutInsightSelectorsResponse' => [ 'type' => 'structure', 'members' => [ 'TrailARN' => [ 'shape' => 'String', ], 'InsightSelectors' => [ 'shape' => 'InsightSelectors', ], ], ], 'Queries' => [ 'type' => 'list', 'member' => [ 'shape' => 'Query', ], ], 'Query' => [ 'type' => 'structure', 'members' => [ 'QueryId' => [ 'shape' => 'UUID', ], 'QueryStatus' => [ 'shape' => 'QueryStatus', ], 'CreationTime' => [ 'shape' => 'Date', ], ], ], 'QueryIdNotFoundException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'QueryResultColumn' => [ 'type' => 'map', 'key' => [ 'shape' => 'QueryResultKey', ], 'value' => [ 'shape' => 'QueryResultValue', ], ], 'QueryResultKey' => [ 'type' => 'string', ], 'QueryResultRow' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueryResultColumn', ], ], 'QueryResultRows' => [ 'type' => 'list', 'member' => [ 'shape' => 'QueryResultRow', ], ], 'QueryResultValue' => [ 'type' => 'string', ], 'QueryStatement' => [ 'type' => 'string', 'max' => 10000, 'min' => 1, 'pattern' => '(?s).*', ], 'QueryStatistics' => [ 'type' => 'structure', 'members' => [ 'ResultsCount' => [ 'shape' => 'Integer', ], 'TotalResultsCount' => [ 'shape' => 'Integer', ], 'BytesScanned' => [ 'shape' => 'Long', ], ], ], 'QueryStatisticsForDescribeQuery' => [ 'type' => 'structure', 'members' => [ 'EventsMatched' => [ 'shape' => 'Long', ], 'EventsScanned' => [ 'shape' => 'Long', ], 'BytesScanned' => [ 'shape' => 'Long', ], 'ExecutionTimeInMillis' => [ 'shape' => 'Integer', ], 'CreationTime' => [ 'shape' => 'Date', ], ], ], 'QueryStatus' => [ 'type' => 'string', 'enum' => [ 'QUEUED', 'RUNNING', 'FINISHED', 'FAILED', 'CANCELLED', 'TIMED_OUT', ], ], 'ReadWriteType' => [ 'type' => 'string', 'enum' => [ 'ReadOnly', 'WriteOnly', 'All', ], ], 'RemoveTagsRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceId', 'TagsList', ], 'members' => [ 'ResourceId' => [ 'shape' => 'String', ], 'TagsList' => [ 'shape' => 'TagsList', ], ], ], 'RemoveTagsResponse' => [ 'type' => 'structure', 'members' => [], ], 'Resource' => [ 'type' => 'structure', 'members' => [ 'ResourceType' => [ 'shape' => 'String', ], 'ResourceName' => [ 'shape' => 'String', ], ], ], 'ResourceIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'ResourceList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Resource', ], ], 'ResourceNotFoundException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'ResourceTag' => [ 'type' => 'structure', 'members' => [ 'ResourceId' => [ 'shape' => 'String', ], 'TagsList' => [ 'shape' => 'TagsList', ], ], ], 'ResourceTagList' => [ 'type' => 'list', 'member' => [ 'shape' => 'ResourceTag', ], ], 'ResourceTypeNotSupportedException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'RestoreEventDataStoreRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], ], ], 'RestoreEventDataStoreResponse' => [ 'type' => 'structure', 'members' => [ 'EventDataStoreArn' => [ 'shape' => 'EventDataStoreArn', ], 'Name' => [ 'shape' => 'EventDataStoreName', ], 'Status' => [ 'shape' => 'EventDataStoreStatus', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], 'CreatedTimestamp' => [ 'shape' => 'Date', ], 'UpdatedTimestamp' => [ 'shape' => 'Date', ], ], ], 'RetentionPeriod' => [ 'type' => 'integer', 'max' => 2555, 'min' => 7, ], 'S3BucketDoesNotExistException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'SelectorField' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '[\\w|\\d|\\.|_]+', ], 'SelectorName' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, 'pattern' => '.*', ], 'StartLoggingRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], ], ], 'StartLoggingResponse' => [ 'type' => 'structure', 'members' => [], ], 'StartQueryRequest' => [ 'type' => 'structure', 'required' => [ 'QueryStatement', ], 'members' => [ 'QueryStatement' => [ 'shape' => 'QueryStatement', ], ], ], 'StartQueryResponse' => [ 'type' => 'structure', 'members' => [ 'QueryId' => [ 'shape' => 'UUID', ], ], ], 'StopLoggingRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], ], ], 'StopLoggingResponse' => [ 'type' => 'structure', 'members' => [], ], 'String' => [ 'type' => 'string', ], 'Tag' => [ 'type' => 'structure', 'required' => [ 'Key', ], 'members' => [ 'Key' => [ 'shape' => 'TagKey', ], 'Value' => [ 'shape' => 'TagValue', ], ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'min' => 1, ], 'TagsLimitExceededException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'TagsList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Tag', ], 'max' => 200, ], 'TerminationProtectionEnabled' => [ 'type' => 'boolean', ], 'Trail' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'String', ], 'S3BucketName' => [ 'shape' => 'String', ], 'S3KeyPrefix' => [ 'shape' => 'String', ], 'SnsTopicName' => [ 'shape' => 'String', 'deprecated' => true, ], 'SnsTopicARN' => [ 'shape' => 'String', ], 'IncludeGlobalServiceEvents' => [ 'shape' => 'Boolean', ], 'IsMultiRegionTrail' => [ 'shape' => 'Boolean', ], 'HomeRegion' => [ 'shape' => 'String', ], 'TrailARN' => [ 'shape' => 'String', ], 'LogFileValidationEnabled' => [ 'shape' => 'Boolean', ], 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'String', ], 'CloudWatchLogsRoleArn' => [ 'shape' => 'String', ], 'KmsKeyId' => [ 'shape' => 'String', ], 'HasCustomEventSelectors' => [ 'shape' => 'Boolean', ], 'HasInsightSelectors' => [ 'shape' => 'Boolean', ], 'IsOrganizationTrail' => [ 'shape' => 'Boolean', ], ], ], 'TrailAlreadyExistsException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'TrailInfo' => [ 'type' => 'structure', 'members' => [ 'TrailARN' => [ 'shape' => 'String', ], 'Name' => [ 'shape' => 'String', ], 'HomeRegion' => [ 'shape' => 'String', ], ], ], 'TrailList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Trail', ], ], 'TrailNameList' => [ 'type' => 'list', 'member' => [ 'shape' => 'String', ], ], 'TrailNotFoundException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'TrailNotProvidedException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'Trails' => [ 'type' => 'list', 'member' => [ 'shape' => 'TrailInfo', ], ], 'UUID' => [ 'type' => 'string', 'max' => 36, 'min' => 36, 'pattern' => '^[a-f0-9\\-]+$', ], 'UnsupportedOperationException' => [ 'type' => 'structure', 'members' => [], 'exception' => true, ], 'UpdateEventDataStoreRequest' => [ 'type' => 'structure', 'required' => [ 'EventDataStore', ], 'members' => [ 'EventDataStore' => [ 'shape' => 'EventDataStoreArn', ], 'Name' => [ 'shape' => 'EventDataStoreName', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], ], ], 'UpdateEventDataStoreResponse' => [ 'type' => 'structure', 'members' => [ 'EventDataStoreArn' => [ 'shape' => 'EventDataStoreArn', ], 'Name' => [ 'shape' => 'EventDataStoreName', ], 'Status' => [ 'shape' => 'EventDataStoreStatus', ], 'AdvancedEventSelectors' => [ 'shape' => 'AdvancedEventSelectors', ], 'MultiRegionEnabled' => [ 'shape' => 'Boolean', ], 'OrganizationEnabled' => [ 'shape' => 'Boolean', ], 'RetentionPeriod' => [ 'shape' => 'RetentionPeriod', ], 'TerminationProtectionEnabled' => [ 'shape' => 'TerminationProtectionEnabled', ], 'CreatedTimestamp' => [ 'shape' => 'Date', ], 'UpdatedTimestamp' => [ 'shape' => 'Date', ], ], ], 'UpdateTrailRequest' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'String', ], 'S3BucketName' => [ 'shape' => 'String', ], 'S3KeyPrefix' => [ 'shape' => 'String', ], 'SnsTopicName' => [ 'shape' => 'String', ], 'IncludeGlobalServiceEvents' => [ 'shape' => 'Boolean', ], 'IsMultiRegionTrail' => [ 'shape' => 'Boolean', ], 'EnableLogFileValidation' => [ 'shape' => 'Boolean', ], 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'String', ], 'CloudWatchLogsRoleArn' => [ 'shape' => 'String', ], 'KmsKeyId' => [ 'shape' => 'String', ], 'IsOrganizationTrail' => [ 'shape' => 'Boolean', ], ], ], 'UpdateTrailResponse' => [ 'type' => 'structure', 'members' => [ 'Name' => [ 'shape' => 'String', ], 'S3BucketName' => [ 'shape' => 'String', ], 'S3KeyPrefix' => [ 'shape' => 'String', ], 'SnsTopicName' => [ 'shape' => 'String', 'deprecated' => true, ], 'SnsTopicARN' => [ 'shape' => 'String', ], 'IncludeGlobalServiceEvents' => [ 'shape' => 'Boolean', ], 'IsMultiRegionTrail' => [ 'shape' => 'Boolean', ], 'TrailARN' => [ 'shape' => 'String', ], 'LogFileValidationEnabled' => [ 'shape' => 'Boolean', ], 'CloudWatchLogsLogGroupArn' => [ 'shape' => 'String', ], 'CloudWatchLogsRoleArn' => [ 'shape' => 'String', ], 'KmsKeyId' => [ 'shape' => 'String', ], 'IsOrganizationTrail' => [ 'shape' => 'Boolean', ], ], ], ],];
