<?php
// This file was auto-generated from sdk-root/src/data/outposts/2019-12-03/api-2.json
return [ 'version' => '2.0', 'metadata' => [ 'apiVersion' => '2019-12-03', 'endpointPrefix' => 'outposts', 'jsonVersion' => '1.1', 'protocol' => 'rest-json', 'serviceAbbreviation' => 'Outposts', 'serviceFullName' => 'AWS Outposts', 'serviceId' => 'Outposts', 'signatureVersion' => 'v4', 'signingName' => 'outposts', 'uid' => 'outposts-2019-12-03', ], 'operations' => [ 'CancelOrder' => [ 'name' => 'CancelOrder', 'http' => [ 'method' => 'POST', 'requestUri' => '/orders/{OrderId}/cancel', ], 'input' => [ 'shape' => 'CancelOrderInput', ], 'output' => [ 'shape' => 'CancelOrderOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'CreateOrder' => [ 'name' => 'CreateOrder', 'http' => [ 'method' => 'POST', 'requestUri' => '/orders', ], 'input' => [ 'shape' => 'CreateOrderInput', ], 'output' => [ 'shape' => 'CreateOrderOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'CreateOutpost' => [ 'name' => 'CreateOutpost', 'http' => [ 'method' => 'POST', 'requestUri' => '/outposts', ], 'input' => [ 'shape' => 'CreateOutpostInput', ], 'output' => [ 'shape' => 'CreateOutpostOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'CreateSite' => [ 'name' => 'CreateSite', 'http' => [ 'method' => 'POST', 'requestUri' => '/sites', ], 'input' => [ 'shape' => 'CreateSiteInput', ], 'output' => [ 'shape' => 'CreateSiteOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ServiceQuotaExceededException', ], ], ], 'DeleteOutpost' => [ 'name' => 'DeleteOutpost', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/outposts/{OutpostId}', ], 'input' => [ 'shape' => 'DeleteOutpostInput', ], 'output' => [ 'shape' => 'DeleteOutpostOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'DeleteSite' => [ 'name' => 'DeleteSite', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/sites/{SiteId}', ], 'input' => [ 'shape' => 'DeleteSiteInput', ], 'output' => [ 'shape' => 'DeleteSiteOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetCatalogItem' => [ 'name' => 'GetCatalogItem', 'http' => [ 'method' => 'GET', 'requestUri' => '/catalog/item/{CatalogItemId}', ], 'input' => [ 'shape' => 'GetCatalogItemInput', ], 'output' => [ 'shape' => 'GetCatalogItemOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetOrder' => [ 'name' => 'GetOrder', 'http' => [ 'method' => 'GET', 'requestUri' => '/orders/{OrderId}', ], 'input' => [ 'shape' => 'GetOrderInput', ], 'output' => [ 'shape' => 'GetOrderOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetOutpost' => [ 'name' => 'GetOutpost', 'http' => [ 'method' => 'GET', 'requestUri' => '/outposts/{OutpostId}', ], 'input' => [ 'shape' => 'GetOutpostInput', ], 'output' => [ 'shape' => 'GetOutpostOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetOutpostInstanceTypes' => [ 'name' => 'GetOutpostInstanceTypes', 'http' => [ 'method' => 'GET', 'requestUri' => '/outposts/{OutpostId}/instanceTypes', ], 'input' => [ 'shape' => 'GetOutpostInstanceTypesInput', ], 'output' => [ 'shape' => 'GetOutpostInstanceTypesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSite' => [ 'name' => 'GetSite', 'http' => [ 'method' => 'GET', 'requestUri' => '/sites/{SiteId}', ], 'input' => [ 'shape' => 'GetSiteInput', ], 'output' => [ 'shape' => 'GetSiteOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'GetSiteAddress' => [ 'name' => 'GetSiteAddress', 'http' => [ 'method' => 'GET', 'requestUri' => '/sites/{SiteId}/address', ], 'input' => [ 'shape' => 'GetSiteAddressInput', ], 'output' => [ 'shape' => 'GetSiteAddressOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListCatalogItems' => [ 'name' => 'ListCatalogItems', 'http' => [ 'method' => 'GET', 'requestUri' => '/catalog/items', ], 'input' => [ 'shape' => 'ListCatalogItemsInput', ], 'output' => [ 'shape' => 'ListCatalogItemsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListOrders' => [ 'name' => 'ListOrders', 'http' => [ 'method' => 'GET', 'requestUri' => '/list-orders', ], 'input' => [ 'shape' => 'ListOrdersInput', ], 'output' => [ 'shape' => 'ListOrdersOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListOutposts' => [ 'name' => 'ListOutposts', 'http' => [ 'method' => 'GET', 'requestUri' => '/outposts', ], 'input' => [ 'shape' => 'ListOutpostsInput', ], 'output' => [ 'shape' => 'ListOutpostsOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListSites' => [ 'name' => 'ListSites', 'http' => [ 'method' => 'GET', 'requestUri' => '/sites', ], 'input' => [ 'shape' => 'ListSitesInput', ], 'output' => [ 'shape' => 'ListSitesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'ListTagsForResource' => [ 'name' => 'ListTagsForResource', 'http' => [ 'method' => 'GET', 'requestUri' => '/tags/{ResourceArn}', ], 'input' => [ 'shape' => 'ListTagsForResourceRequest', ], 'output' => [ 'shape' => 'ListTagsForResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], ], ], 'TagResource' => [ 'name' => 'TagResource', 'http' => [ 'method' => 'POST', 'requestUri' => '/tags/{ResourceArn}', ], 'input' => [ 'shape' => 'TagResourceRequest', ], 'output' => [ 'shape' => 'TagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], ], ], 'UntagResource' => [ 'name' => 'UntagResource', 'http' => [ 'method' => 'DELETE', 'requestUri' => '/tags/{ResourceArn}', ], 'input' => [ 'shape' => 'UntagResourceRequest', ], 'output' => [ 'shape' => 'UntagResourceResponse', ], 'errors' => [ [ 'shape' => 'InternalServerException', ], [ 'shape' => 'ValidationException', ], [ 'shape' => 'NotFoundException', ], ], ], 'UpdateOutpost' => [ 'name' => 'UpdateOutpost', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/outposts/{OutpostId}', ], 'input' => [ 'shape' => 'UpdateOutpostInput', ], 'output' => [ 'shape' => 'UpdateOutpostOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateSite' => [ 'name' => 'UpdateSite', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/sites/{SiteId}', ], 'input' => [ 'shape' => 'UpdateSiteInput', ], 'output' => [ 'shape' => 'UpdateSiteOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateSiteAddress' => [ 'name' => 'UpdateSiteAddress', 'http' => [ 'method' => 'PUT', 'requestUri' => '/sites/{SiteId}/address', ], 'input' => [ 'shape' => 'UpdateSiteAddressInput', ], 'output' => [ 'shape' => 'UpdateSiteAddressOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'InternalServerException', ], ], ], 'UpdateSiteRackPhysicalProperties' => [ 'name' => 'UpdateSiteRackPhysicalProperties', 'http' => [ 'method' => 'PATCH', 'requestUri' => '/sites/{SiteId}/rackPhysicalProperties', ], 'input' => [ 'shape' => 'UpdateSiteRackPhysicalPropertiesInput', ], 'output' => [ 'shape' => 'UpdateSiteRackPhysicalPropertiesOutput', ], 'errors' => [ [ 'shape' => 'ValidationException', ], [ 'shape' => 'ConflictException', ], [ 'shape' => 'NotFoundException', ], [ 'shape' => 'AccessDeniedException', ], [ 'shape' => 'InternalServerException', ], ], ], ], 'shapes' => [ 'AccessDeniedException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 403, ], 'exception' => true, ], 'AccountId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d{12}', ], 'Address' => [ 'type' => 'structure', 'required' => [ 'AddressLine1', 'City', 'StateOrRegion', 'PostalCode', 'CountryCode', ], 'members' => [ 'ContactName' => [ 'shape' => 'ContactName', ], 'ContactPhoneNumber' => [ 'shape' => 'ContactPhoneNumber', ], 'AddressLine1' => [ 'shape' => 'AddressLine1', ], 'AddressLine2' => [ 'shape' => 'AddressLine2', ], 'AddressLine3' => [ 'shape' => 'AddressLine3', ], 'City' => [ 'shape' => 'City', ], 'StateOrRegion' => [ 'shape' => 'StateOrRegion', ], 'DistrictOrCounty' => [ 'shape' => 'DistrictOrCounty', ], 'PostalCode' => [ 'shape' => 'PostalCode', ], 'CountryCode' => [ 'shape' => 'CountryCode', ], 'Municipality' => [ 'shape' => 'Municipality', ], ], ], 'AddressLine1' => [ 'type' => 'string', 'max' => 180, 'min' => 1, 'pattern' => '^\\S[\\S ]*$', ], 'AddressLine2' => [ 'type' => 'string', 'max' => 60, 'min' => 0, 'pattern' => '^\\S[\\S ]*$', ], 'AddressLine3' => [ 'type' => 'string', 'max' => 60, 'min' => 0, 'pattern' => '^\\S[\\S ]*$', ], 'AddressType' => [ 'type' => 'string', 'enum' => [ 'SHIPPING_ADDRESS', 'OPERATING_ADDRESS', ], ], 'Arn' => [ 'type' => 'string', 'max' => 1011, 'pattern' => '^(arn:aws([a-z-]+)?:outposts:[a-z\\d-]+:\\d{12}:([a-z\\d-]+)/)[a-z]{2,8}-[a-f0-9]{17}$', ], 'AvailabilityZone' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '^([a-zA-Z]+-){1,3}([a-zA-Z]+)?(\\d+[a-zA-Z]?)?$', ], 'AvailabilityZoneId' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[a-zA-Z]+\\d-[a-zA-Z]+\\d$', ], 'AvailabilityZoneIdList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AvailabilityZoneId', ], 'max' => 5, 'min' => 1, ], 'AvailabilityZoneList' => [ 'type' => 'list', 'member' => [ 'shape' => 'AvailabilityZone', ], 'max' => 5, 'min' => 1, ], 'CancelOrderInput' => [ 'type' => 'structure', 'required' => [ 'OrderId', ], 'members' => [ 'OrderId' => [ 'shape' => 'OrderId', 'location' => 'uri', 'locationName' => 'OrderId', ], ], ], 'CancelOrderOutput' => [ 'type' => 'structure', 'members' => [], ], 'CatalogItem' => [ 'type' => 'structure', 'members' => [ 'CatalogItemId' => [ 'shape' => 'SkuCode', ], 'ItemStatus' => [ 'shape' => 'CatalogItemStatus', ], 'EC2Capacities' => [ 'shape' => 'EC2CapacityListDefinition', ], 'PowerKva' => [ 'shape' => 'CatalogItemPowerKva', ], 'WeightLbs' => [ 'shape' => 'CatalogItemWeightLbs', ], 'SupportedUplinkGbps' => [ 'shape' => 'SupportedUplinkGbpsListDefinition', ], 'SupportedStorage' => [ 'shape' => 'SupportedStorageList', ], ], ], 'CatalogItemClass' => [ 'type' => 'string', 'enum' => [ 'RACK', 'SERVER', ], ], 'CatalogItemClassList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CatalogItemClass', ], ], 'CatalogItemListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'CatalogItem', ], ], 'CatalogItemPowerKva' => [ 'type' => 'float', 'box' => true, ], 'CatalogItemStatus' => [ 'type' => 'string', 'enum' => [ 'AVAILABLE', 'DISCONTINUED', ], ], 'CatalogItemWeightLbs' => [ 'type' => 'integer', 'box' => true, ], 'City' => [ 'type' => 'string', 'max' => 50, 'min' => 1, 'pattern' => '^\\S[\\S ]*$', ], 'CityList' => [ 'type' => 'list', 'member' => [ 'shape' => 'City', ], ], 'ConflictException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], 'ResourceId' => [ 'shape' => 'String', ], 'ResourceType' => [ 'shape' => 'ResourceType', ], ], 'error' => [ 'httpStatusCode' => 409, ], 'exception' => true, ], 'ContactName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^\\S[\\S ]*$', ], 'ContactPhoneNumber' => [ 'type' => 'string', 'max' => 20, 'min' => 1, 'pattern' => '^[\\S ]+$', ], 'CountryCode' => [ 'type' => 'string', 'max' => 2, 'min' => 2, 'pattern' => '^[A-Z]{2}$', ], 'CountryCodeList' => [ 'type' => 'list', 'member' => [ 'shape' => 'CountryCode', ], ], 'CreateOrderInput' => [ 'type' => 'structure', 'required' => [ 'OutpostIdentifier', 'LineItems', 'PaymentOption', ], 'members' => [ 'OutpostIdentifier' => [ 'shape' => 'OutpostIdentifier', ], 'LineItems' => [ 'shape' => 'LineItemRequestListDefinition', ], 'PaymentOption' => [ 'shape' => 'PaymentOption', ], 'PaymentTerm' => [ 'shape' => 'PaymentTerm', ], ], ], 'CreateOrderOutput' => [ 'type' => 'structure', 'members' => [ 'Order' => [ 'shape' => 'Order', ], ], ], 'CreateOutpostInput' => [ 'type' => 'structure', 'required' => [ 'Name', 'SiteId', ], 'members' => [ 'Name' => [ 'shape' => 'OutpostName', ], 'Description' => [ 'shape' => 'OutpostDescription', ], 'SiteId' => [ 'shape' => 'SiteId', ], 'AvailabilityZone' => [ 'shape' => 'AvailabilityZone', ], 'AvailabilityZoneId' => [ 'shape' => 'AvailabilityZoneId', ], 'Tags' => [ 'shape' => 'TagMap', ], 'SupportedHardwareType' => [ 'shape' => 'SupportedHardwareType', ], ], ], 'CreateOutpostOutput' => [ 'type' => 'structure', 'members' => [ 'Outpost' => [ 'shape' => 'Outpost', ], ], ], 'CreateSiteInput' => [ 'type' => 'structure', 'required' => [ 'Name', ], 'members' => [ 'Name' => [ 'shape' => 'SiteName', ], 'Description' => [ 'shape' => 'SiteDescription', ], 'Notes' => [ 'shape' => 'SiteNotes', ], 'Tags' => [ 'shape' => 'TagMap', ], 'OperatingAddress' => [ 'shape' => 'Address', ], 'ShippingAddress' => [ 'shape' => 'Address', ], 'RackPhysicalProperties' => [ 'shape' => 'RackPhysicalProperties', ], ], ], 'CreateSiteOutput' => [ 'type' => 'structure', 'members' => [ 'Site' => [ 'shape' => 'Site', ], ], ], 'DeleteOutpostInput' => [ 'type' => 'structure', 'required' => [ 'OutpostId', ], 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostId', 'location' => 'uri', 'locationName' => 'OutpostId', ], ], ], 'DeleteOutpostOutput' => [ 'type' => 'structure', 'members' => [], ], 'DeleteSiteInput' => [ 'type' => 'structure', 'required' => [ 'SiteId', ], 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', 'location' => 'uri', 'locationName' => 'SiteId', ], ], ], 'DeleteSiteOutput' => [ 'type' => 'structure', 'members' => [], ], 'DistrictOrCounty' => [ 'type' => 'string', 'max' => 60, 'min' => 1, 'pattern' => '^\\S[\\S ]*', ], 'EC2Capacity' => [ 'type' => 'structure', 'members' => [ 'Family' => [ 'shape' => 'Family', ], 'MaxSize' => [ 'shape' => 'MaxSize', ], 'Quantity' => [ 'shape' => 'Quantity', ], ], ], 'EC2CapacityListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'EC2Capacity', ], ], 'EC2FamilyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'Family', ], ], 'ErrorMessage' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '^[\\S \\n]+$', ], 'Family' => [ 'type' => 'string', 'max' => 10, 'min' => 1, 'pattern' => '[a-z0-9]+', ], 'FiberOpticCableType' => [ 'type' => 'string', 'enum' => [ 'SINGLE_MODE', 'MULTI_MODE', ], ], 'GetCatalogItemInput' => [ 'type' => 'structure', 'required' => [ 'CatalogItemId', ], 'members' => [ 'CatalogItemId' => [ 'shape' => 'SkuCode', 'location' => 'uri', 'locationName' => 'CatalogItemId', ], ], ], 'GetCatalogItemOutput' => [ 'type' => 'structure', 'members' => [ 'CatalogItem' => [ 'shape' => 'CatalogItem', ], ], ], 'GetOrderInput' => [ 'type' => 'structure', 'required' => [ 'OrderId', ], 'members' => [ 'OrderId' => [ 'shape' => 'OrderId', 'location' => 'uri', 'locationName' => 'OrderId', ], ], ], 'GetOrderOutput' => [ 'type' => 'structure', 'members' => [ 'Order' => [ 'shape' => 'Order', ], ], ], 'GetOutpostInput' => [ 'type' => 'structure', 'required' => [ 'OutpostId', ], 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostId', 'location' => 'uri', 'locationName' => 'OutpostId', ], ], ], 'GetOutpostInstanceTypesInput' => [ 'type' => 'structure', 'required' => [ 'OutpostId', ], 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostId', 'location' => 'uri', 'locationName' => 'OutpostId', ], 'NextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults1000', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'GetOutpostInstanceTypesOutput' => [ 'type' => 'structure', 'members' => [ 'InstanceTypes' => [ 'shape' => 'InstanceTypeListDefinition', ], 'NextToken' => [ 'shape' => 'Token', ], 'OutpostId' => [ 'shape' => 'OutpostId', ], 'OutpostArn' => [ 'shape' => 'OutpostArn', ], ], ], 'GetOutpostOutput' => [ 'type' => 'structure', 'members' => [ 'Outpost' => [ 'shape' => 'Outpost', ], ], ], 'GetSiteAddressInput' => [ 'type' => 'structure', 'required' => [ 'SiteId', 'AddressType', ], 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', 'location' => 'uri', 'locationName' => 'SiteId', ], 'AddressType' => [ 'shape' => 'AddressType', 'location' => 'querystring', 'locationName' => 'AddressType', ], ], ], 'GetSiteAddressOutput' => [ 'type' => 'structure', 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', ], 'AddressType' => [ 'shape' => 'AddressType', ], 'Address' => [ 'shape' => 'Address', ], ], ], 'GetSiteInput' => [ 'type' => 'structure', 'required' => [ 'SiteId', ], 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', 'location' => 'uri', 'locationName' => 'SiteId', ], ], ], 'GetSiteOutput' => [ 'type' => 'structure', 'members' => [ 'Site' => [ 'shape' => 'Site', ], ], ], 'ISO8601Timestamp' => [ 'type' => 'timestamp', ], 'InstanceType' => [ 'type' => 'string', ], 'InstanceTypeItem' => [ 'type' => 'structure', 'members' => [ 'InstanceType' => [ 'shape' => 'InstanceType', ], ], ], 'InstanceTypeListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'InstanceTypeItem', ], ], 'InternalServerException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 500, ], 'exception' => true, ], 'LifeCycleStatus' => [ 'type' => 'string', 'max' => 20, 'min' => 1, 'pattern' => '^[ A-Za-z]+$', ], 'LifeCycleStatusList' => [ 'type' => 'list', 'member' => [ 'shape' => 'LifeCycleStatus', ], 'max' => 5, 'min' => 1, ], 'LineItem' => [ 'type' => 'structure', 'members' => [ 'CatalogItemId' => [ 'shape' => 'SkuCode', ], 'LineItemId' => [ 'shape' => 'LineItemId', ], 'Quantity' => [ 'shape' => 'LineItemQuantity', ], 'Status' => [ 'shape' => 'LineItemStatus', ], ], ], 'LineItemId' => [ 'type' => 'string', 'pattern' => 'ooi-[a-f0-9]{17}', ], 'LineItemListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'LineItem', ], ], 'LineItemQuantity' => [ 'type' => 'integer', 'max' => 20, 'min' => 1, ], 'LineItemRequest' => [ 'type' => 'structure', 'members' => [ 'CatalogItemId' => [ 'shape' => 'SkuCode', ], 'Quantity' => [ 'shape' => 'LineItemQuantity', ], ], ], 'LineItemRequestListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'LineItemRequest', ], 'max' => 20, 'min' => 1, ], 'LineItemStatus' => [ 'type' => 'string', 'enum' => [ 'PREPARING', 'BUILDING', 'SHIPPED', 'DELIVERED', 'INSTALLING', 'INSTALLED', 'ERROR', 'CANCELLED', ], ], 'LineItemStatusCounts' => [ 'type' => 'map', 'key' => [ 'shape' => 'LineItemStatus', ], 'value' => [ 'shape' => 'LineItemQuantity', ], ], 'ListCatalogItemsInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults1000', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'ItemClassFilter' => [ 'shape' => 'CatalogItemClassList', 'location' => 'querystring', 'locationName' => 'ItemClassFilter', ], 'SupportedStorageFilter' => [ 'shape' => 'SupportedStorageList', 'location' => 'querystring', 'locationName' => 'SupportedStorageFilter', ], 'EC2FamilyFilter' => [ 'shape' => 'EC2FamilyList', 'location' => 'querystring', 'locationName' => 'EC2FamilyFilter', ], ], ], 'ListCatalogItemsOutput' => [ 'type' => 'structure', 'members' => [ 'CatalogItems' => [ 'shape' => 'CatalogItemListDefinition', ], 'NextToken' => [ 'shape' => 'Token', ], ], ], 'ListOrdersInput' => [ 'type' => 'structure', 'members' => [ 'OutpostIdentifierFilter' => [ 'shape' => 'OutpostIdentifier', 'location' => 'querystring', 'locationName' => 'OutpostIdentifierFilter', ], 'NextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults1000', 'location' => 'querystring', 'locationName' => 'MaxResults', ], ], ], 'ListOrdersOutput' => [ 'type' => 'structure', 'members' => [ 'Orders' => [ 'shape' => 'OrderSummaryListDefinition', ], 'NextToken' => [ 'shape' => 'Token', ], ], ], 'ListOutpostsInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults1000', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'LifeCycleStatusFilter' => [ 'shape' => 'LifeCycleStatusList', 'location' => 'querystring', 'locationName' => 'LifeCycleStatusFilter', ], 'AvailabilityZoneFilter' => [ 'shape' => 'AvailabilityZoneList', 'location' => 'querystring', 'locationName' => 'AvailabilityZoneFilter', ], 'AvailabilityZoneIdFilter' => [ 'shape' => 'AvailabilityZoneIdList', 'location' => 'querystring', 'locationName' => 'AvailabilityZoneIdFilter', ], ], ], 'ListOutpostsOutput' => [ 'type' => 'structure', 'members' => [ 'Outposts' => [ 'shape' => 'outpostListDefinition', ], 'NextToken' => [ 'shape' => 'Token', ], ], ], 'ListSitesInput' => [ 'type' => 'structure', 'members' => [ 'NextToken' => [ 'shape' => 'Token', 'location' => 'querystring', 'locationName' => 'NextToken', ], 'MaxResults' => [ 'shape' => 'MaxResults1000', 'location' => 'querystring', 'locationName' => 'MaxResults', ], 'OperatingAddressCountryCodeFilter' => [ 'shape' => 'CountryCodeList', 'location' => 'querystring', 'locationName' => 'OperatingAddressCountryCodeFilter', ], 'OperatingAddressStateOrRegionFilter' => [ 'shape' => 'StateOrRegionList', 'location' => 'querystring', 'locationName' => 'OperatingAddressStateOrRegionFilter', ], 'OperatingAddressCityFilter' => [ 'shape' => 'CityList', 'location' => 'querystring', 'locationName' => 'OperatingAddressCityFilter', ], ], ], 'ListSitesOutput' => [ 'type' => 'structure', 'members' => [ 'Sites' => [ 'shape' => 'siteListDefinition', ], 'NextToken' => [ 'shape' => 'Token', ], ], ], 'ListTagsForResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'ResourceArn', ], ], ], 'ListTagsForResourceResponse' => [ 'type' => 'structure', 'members' => [ 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'MaxResults1000' => [ 'type' => 'integer', 'box' => true, 'max' => 1000, 'min' => 1, ], 'MaxSize' => [ 'type' => 'string', ], 'MaximumSupportedWeightLbs' => [ 'type' => 'string', 'enum' => [ 'NO_LIMIT', 'MAX_1400_LBS', 'MAX_1600_LBS', 'MAX_1800_LBS', 'MAX_2000_LBS', ], ], 'Municipality' => [ 'type' => 'string', 'max' => 180, 'min' => 0, 'pattern' => '^\\S[\\S ]*$', ], 'NotFoundException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 404, ], 'exception' => true, ], 'OpticalStandard' => [ 'type' => 'string', 'enum' => [ 'OPTIC_10GBASE_SR', 'OPTIC_10GBASE_IR', 'OPTIC_10GBASE_LR', 'OPTIC_40GBASE_SR', 'OPTIC_40GBASE_ESR', 'OPTIC_40GBASE_IR4_LR4L', 'OPTIC_40GBASE_LR4', 'OPTIC_100GBASE_SR4', 'OPTIC_100GBASE_CWDM4', 'OPTIC_100GBASE_LR4', 'OPTIC_100G_PSM4_MSA', 'OPTIC_1000BASE_LX', 'OPTIC_1000BASE_SX', ], ], 'Order' => [ 'type' => 'structure', 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostIdOnly', ], 'OrderId' => [ 'shape' => 'OrderId', ], 'Status' => [ 'shape' => 'OrderStatus', ], 'LineItems' => [ 'shape' => 'LineItemListDefinition', ], 'PaymentOption' => [ 'shape' => 'PaymentOption', ], 'OrderSubmissionDate' => [ 'shape' => 'ISO8601Timestamp', ], 'OrderFulfilledDate' => [ 'shape' => 'ISO8601Timestamp', ], ], ], 'OrderId' => [ 'type' => 'string', 'max' => 20, 'min' => 1, 'pattern' => 'oo-[a-f0-9]{17}$', ], 'OrderStatus' => [ 'type' => 'string', 'enum' => [ 'RECEIVED', 'PENDING', 'PROCESSING', 'INSTALLING', 'FULFILLED', 'CANCELLED', 'PREPARING', 'IN_PROGRESS', 'COMPLETED', 'ERROR', ], ], 'OrderSummary' => [ 'type' => 'structure', 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostIdOnly', ], 'OrderId' => [ 'shape' => 'OrderId', ], 'OrderType' => [ 'shape' => 'OrderType', ], 'Status' => [ 'shape' => 'OrderStatus', ], 'LineItemCountsByStatus' => [ 'shape' => 'LineItemStatusCounts', ], 'OrderSubmissionDate' => [ 'shape' => 'ISO8601Timestamp', ], 'OrderFulfilledDate' => [ 'shape' => 'ISO8601Timestamp', ], ], ], 'OrderSummaryListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'OrderSummary', ], ], 'OrderType' => [ 'type' => 'string', 'enum' => [ 'OUTPOST', 'REPLACEMENT', ], ], 'Outpost' => [ 'type' => 'structure', 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostId', ], 'OwnerId' => [ 'shape' => 'OwnerId', ], 'OutpostArn' => [ 'shape' => 'OutpostArn', ], 'SiteId' => [ 'shape' => 'SiteId', ], 'Name' => [ 'shape' => 'OutpostName', ], 'Description' => [ 'shape' => 'OutpostDescription', ], 'LifeCycleStatus' => [ 'shape' => 'LifeCycleStatus', ], 'AvailabilityZone' => [ 'shape' => 'AvailabilityZone', ], 'AvailabilityZoneId' => [ 'shape' => 'AvailabilityZoneId', ], 'Tags' => [ 'shape' => 'TagMap', ], 'SiteArn' => [ 'shape' => 'SiteArn', ], 'SupportedHardwareType' => [ 'shape' => 'SupportedHardwareType', ], ], ], 'OutpostArn' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^arn:aws([a-z-]+)?:outposts:[a-z\\d-]+:\\d{12}:outpost/op-[a-f0-9]{17}$', ], 'OutpostDescription' => [ 'type' => 'string', 'max' => 1000, 'min' => 0, 'pattern' => '^[\\S ]*$', ], 'OutpostId' => [ 'type' => 'string', 'max' => 180, 'min' => 1, 'pattern' => '^(arn:aws([a-z-]+)?:outposts:[a-z\\d-]+:\\d{12}:outpost/)?op-[a-f0-9]{17}$', ], 'OutpostIdOnly' => [ 'type' => 'string', 'max' => 20, 'min' => 1, 'pattern' => '^op-[a-f0-9]{17}$', ], 'OutpostIdentifier' => [ 'type' => 'string', 'max' => 180, 'min' => 1, 'pattern' => '^(arn:aws([a-z-]+)?:outposts:[a-z\\d-]+:\\d{12}:outpost/)?op-[a-f0-9]{17}$', ], 'OutpostName' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^[\\S ]+$', ], 'OwnerId' => [ 'type' => 'string', 'max' => 12, 'min' => 12, 'pattern' => '\\d{12}', ], 'PaymentOption' => [ 'type' => 'string', 'enum' => [ 'ALL_UPFRONT', 'NO_UPFRONT', 'PARTIAL_UPFRONT', ], ], 'PaymentTerm' => [ 'type' => 'string', 'enum' => [ 'THREE_YEARS', ], ], 'PostalCode' => [ 'type' => 'string', 'max' => 20, 'min' => 1, 'pattern' => '^[a-zA-Z0-9 -]+$', ], 'PowerConnector' => [ 'type' => 'string', 'enum' => [ 'L6_30P', 'IEC309', 'AH530P7W', 'AH532P6W', ], ], 'PowerDrawKva' => [ 'type' => 'string', 'enum' => [ 'POWER_5_KVA', 'POWER_10_KVA', 'POWER_15_KVA', ], ], 'PowerFeedDrop' => [ 'type' => 'string', 'enum' => [ 'ABOVE_RACK', 'BELOW_RACK', ], ], 'PowerPhase' => [ 'type' => 'string', 'enum' => [ 'SINGLE_PHASE', 'THREE_PHASE', ], ], 'Quantity' => [ 'type' => 'string', ], 'RackPhysicalProperties' => [ 'type' => 'structure', 'members' => [ 'PowerDrawKva' => [ 'shape' => 'PowerDrawKva', ], 'PowerPhase' => [ 'shape' => 'PowerPhase', ], 'PowerConnector' => [ 'shape' => 'PowerConnector', ], 'PowerFeedDrop' => [ 'shape' => 'PowerFeedDrop', ], 'UplinkGbps' => [ 'shape' => 'UplinkGbps', ], 'UplinkCount' => [ 'shape' => 'UplinkCount', ], 'FiberOpticCableType' => [ 'shape' => 'FiberOpticCableType', ], 'OpticalStandard' => [ 'shape' => 'OpticalStandard', ], 'MaximumSupportedWeightLbs' => [ 'shape' => 'MaximumSupportedWeightLbs', ], ], ], 'ResourceType' => [ 'type' => 'string', 'enum' => [ 'OUTPOST', 'ORDER', ], ], 'ServiceQuotaExceededException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 402, ], 'exception' => true, ], 'Site' => [ 'type' => 'structure', 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', ], 'AccountId' => [ 'shape' => 'AccountId', ], 'Name' => [ 'shape' => 'SiteName', ], 'Description' => [ 'shape' => 'SiteDescription', ], 'Tags' => [ 'shape' => 'TagMap', ], 'SiteArn' => [ 'shape' => 'SiteArn', ], 'Notes' => [ 'shape' => 'SiteNotes', ], 'OperatingAddressCountryCode' => [ 'shape' => 'CountryCode', ], 'OperatingAddressStateOrRegion' => [ 'shape' => 'StateOrRegion', ], 'OperatingAddressCity' => [ 'shape' => 'City', ], 'RackPhysicalProperties' => [ 'shape' => 'RackPhysicalProperties', ], ], ], 'SiteArn' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^arn:aws([a-z-]+)?:outposts:[a-z\\d-]+:\\d{12}:site/(os-[a-f0-9]{17})$', ], 'SiteDescription' => [ 'type' => 'string', 'max' => 1001, 'min' => 1, 'pattern' => '^[\\S ]+$', ], 'SiteId' => [ 'type' => 'string', 'max' => 255, 'min' => 1, 'pattern' => '^(arn:aws([a-z-]+)?:outposts:[a-z\\d-]+:\\d{12}:site/)?(os-[a-f0-9]{17})$', ], 'SiteName' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '^[\\S ]+$', ], 'SiteNotes' => [ 'type' => 'string', 'max' => 2000, 'min' => 1, 'pattern' => '^[\\S \\n]+$', ], 'SkuCode' => [ 'type' => 'string', 'max' => 10, 'min' => 1, 'pattern' => 'OR-[A-Z0-9]{7}', ], 'StateOrRegion' => [ 'type' => 'string', 'max' => 50, 'min' => 1, 'pattern' => '^\\S[\\S ]*$', ], 'StateOrRegionList' => [ 'type' => 'list', 'member' => [ 'shape' => 'StateOrRegion', ], ], 'String' => [ 'type' => 'string', 'max' => 1000, 'min' => 1, 'pattern' => '^[\\S \\n]+$', ], 'SupportedHardwareType' => [ 'type' => 'string', 'enum' => [ 'RACK', 'SERVER', ], ], 'SupportedStorageEnum' => [ 'type' => 'string', 'enum' => [ 'EBS', 'S3', ], ], 'SupportedStorageList' => [ 'type' => 'list', 'member' => [ 'shape' => 'SupportedStorageEnum', ], ], 'SupportedUplinkGbps' => [ 'type' => 'integer', ], 'SupportedUplinkGbpsListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'SupportedUplinkGbps', ], ], 'TagKey' => [ 'type' => 'string', 'max' => 128, 'min' => 1, 'pattern' => '^(?!aws:)[a-zA-Z+-=._:/]+$', ], 'TagKeyList' => [ 'type' => 'list', 'member' => [ 'shape' => 'TagKey', ], 'max' => 50, 'min' => 1, ], 'TagMap' => [ 'type' => 'map', 'key' => [ 'shape' => 'TagKey', ], 'value' => [ 'shape' => 'TagValue', ], 'max' => 50, 'min' => 1, ], 'TagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'Tags', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'ResourceArn', ], 'Tags' => [ 'shape' => 'TagMap', ], ], ], 'TagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'TagValue' => [ 'type' => 'string', 'max' => 256, 'pattern' => '^[\\S \\n]+$', ], 'Token' => [ 'type' => 'string', 'max' => 1005, 'min' => 1, 'pattern' => '^(\\d+)##(\\S+)$', ], 'UntagResourceRequest' => [ 'type' => 'structure', 'required' => [ 'ResourceArn', 'TagKeys', ], 'members' => [ 'ResourceArn' => [ 'shape' => 'Arn', 'location' => 'uri', 'locationName' => 'ResourceArn', ], 'TagKeys' => [ 'shape' => 'TagKeyList', 'location' => 'querystring', 'locationName' => 'tagKeys', ], ], ], 'UntagResourceResponse' => [ 'type' => 'structure', 'members' => [], ], 'UpdateOutpostInput' => [ 'type' => 'structure', 'required' => [ 'OutpostId', ], 'members' => [ 'OutpostId' => [ 'shape' => 'OutpostId', 'location' => 'uri', 'locationName' => 'OutpostId', ], 'Name' => [ 'shape' => 'OutpostName', ], 'Description' => [ 'shape' => 'OutpostDescription', ], 'SupportedHardwareType' => [ 'shape' => 'SupportedHardwareType', ], ], ], 'UpdateOutpostOutput' => [ 'type' => 'structure', 'members' => [ 'Outpost' => [ 'shape' => 'Outpost', ], ], ], 'UpdateSiteAddressInput' => [ 'type' => 'structure', 'required' => [ 'SiteId', 'AddressType', 'Address', ], 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', 'location' => 'uri', 'locationName' => 'SiteId', ], 'AddressType' => [ 'shape' => 'AddressType', ], 'Address' => [ 'shape' => 'Address', ], ], ], 'UpdateSiteAddressOutput' => [ 'type' => 'structure', 'members' => [ 'AddressType' => [ 'shape' => 'AddressType', ], 'Address' => [ 'shape' => 'Address', ], ], ], 'UpdateSiteInput' => [ 'type' => 'structure', 'required' => [ 'SiteId', ], 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', 'location' => 'uri', 'locationName' => 'SiteId', ], 'Name' => [ 'shape' => 'SiteName', ], 'Description' => [ 'shape' => 'SiteDescription', ], 'Notes' => [ 'shape' => 'SiteNotes', ], ], ], 'UpdateSiteOutput' => [ 'type' => 'structure', 'members' => [ 'Site' => [ 'shape' => 'Site', ], ], ], 'UpdateSiteRackPhysicalPropertiesInput' => [ 'type' => 'structure', 'required' => [ 'SiteId', ], 'members' => [ 'SiteId' => [ 'shape' => 'SiteId', 'location' => 'uri', 'locationName' => 'SiteId', ], 'PowerDrawKva' => [ 'shape' => 'PowerDrawKva', ], 'PowerPhase' => [ 'shape' => 'PowerPhase', ], 'PowerConnector' => [ 'shape' => 'PowerConnector', ], 'PowerFeedDrop' => [ 'shape' => 'PowerFeedDrop', ], 'UplinkGbps' => [ 'shape' => 'UplinkGbps', ], 'UplinkCount' => [ 'shape' => 'UplinkCount', ], 'FiberOpticCableType' => [ 'shape' => 'FiberOpticCableType', ], 'OpticalStandard' => [ 'shape' => 'OpticalStandard', ], 'MaximumSupportedWeightLbs' => [ 'shape' => 'MaximumSupportedWeightLbs', ], ], ], 'UpdateSiteRackPhysicalPropertiesOutput' => [ 'type' => 'structure', 'members' => [ 'Site' => [ 'shape' => 'Site', ], ], ], 'UplinkCount' => [ 'type' => 'string', 'enum' => [ 'UPLINK_COUNT_1', 'UPLINK_COUNT_2', 'UPLINK_COUNT_3', 'UPLINK_COUNT_4', 'UPLINK_COUNT_5', 'UPLINK_COUNT_6', 'UPLINK_COUNT_7', 'UPLINK_COUNT_8', 'UPLINK_COUNT_12', 'UPLINK_COUNT_16', ], ], 'UplinkGbps' => [ 'type' => 'string', 'enum' => [ 'UPLINK_1G', 'UPLINK_10G', 'UPLINK_40G', 'UPLINK_100G', ], ], 'ValidationException' => [ 'type' => 'structure', 'members' => [ 'Message' => [ 'shape' => 'ErrorMessage', ], ], 'error' => [ 'httpStatusCode' => 400, ], 'exception' => true, ], 'outpostListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'Outpost', ], ], 'siteListDefinition' => [ 'type' => 'list', 'member' => [ 'shape' => 'Site', ], ], ],];
