<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/compute/v1/compute.proto

namespace Google\Cloud\Compute\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents a Nat resource. It enables the VMs within the specified subnetworks to access Internet without external IP addresses. It specifies a list of subnetworks (and the ranges within) that want to use NAT. Customers can also provide the external IPs that would be used for NAT. GCP would auto-allocate ephemeral IPs if no external IPs are provided.
 *
 * Generated from protobuf message <code>google.cloud.compute.v1.RouterNat</code>
 */
class RouterNat extends \Google\Protobuf\Internal\Message
{
    /**
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     *
     * Generated from protobuf field <code>repeated string drain_nat_ips = 235643079;</code>
     */
    private $drain_nat_ips;
    /**
     * Generated from protobuf field <code>bool enable_endpoint_independent_mapping = 259441819;</code>
     */
    private $enable_endpoint_independent_mapping = false;
    /**
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 icmp_idle_timeout_sec = 3647562;</code>
     */
    private $icmp_idle_timeout_sec = 0;
    /**
     * Configure logging on this NAT.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNatLogConfig log_config = 82864285;</code>
     */
    private $log_config = null;
    /**
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     *
     * Generated from protobuf field <code>int32 min_ports_per_vm = 186193587;</code>
     */
    private $min_ports_per_vm = 0;
    /**
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     */
    private $name = '';
    /**
     * Specify the NatIpAllocateOption, which can take one of the following values:
     * - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.
     * - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNat.NatIpAllocateOption nat_ip_allocate_option = 161291389;</code>
     */
    private $nat_ip_allocate_option = 0;
    /**
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     *
     * Generated from protobuf field <code>repeated string nat_ips = 117635086;</code>
     */
    private $nat_ips;
    /**
     * Specify the Nat option, which can take one of the following values:
     * - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.
     * - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.
     * - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     */
    private $source_subnetwork_ip_ranges_to_nat = 0;
    /**
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 147417669;</code>
     */
    private $subnetworks;
    /**
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     *
     * Generated from protobuf field <code>int32 tcp_established_idle_timeout_sec = 223098349;</code>
     */
    private $tcp_established_idle_timeout_sec = 0;
    /**
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     */
    private $tcp_transitory_idle_timeout_sec = 0;
    /**
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 udp_idle_timeout_sec = 64919878;</code>
     */
    private $udp_idle_timeout_sec = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $drain_nat_ips
     *           A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     *     @type bool $enable_endpoint_independent_mapping
     *     @type int $icmp_idle_timeout_sec
     *           Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     *     @type \Google\Cloud\Compute\V1\RouterNatLogConfig $log_config
     *           Configure logging on this NAT.
     *     @type int $min_ports_per_vm
     *           Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     *     @type string $name
     *           Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     *     @type int $nat_ip_allocate_option
     *           Specify the NatIpAllocateOption, which can take one of the following values:
     *           - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.
     *           - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $nat_ips
     *           A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     *     @type int $source_subnetwork_ip_ranges_to_nat
     *           Specify the Nat option, which can take one of the following values:
     *           - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.
     *           - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.
     *           - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
     *     @type \Google\Cloud\Compute\V1\RouterNatSubnetworkToNat[]|\Google\Protobuf\Internal\RepeatedField $subnetworks
     *           A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     *     @type int $tcp_established_idle_timeout_sec
     *           Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     *     @type int $tcp_transitory_idle_timeout_sec
     *           Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     *     @type int $udp_idle_timeout_sec
     *           Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Compute\V1\Compute::initOnce();
        parent::__construct($data);
    }

    /**
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     *
     * Generated from protobuf field <code>repeated string drain_nat_ips = 235643079;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDrainNatIps()
    {
        return $this->drain_nat_ips;
    }

    /**
     * A list of URLs of the IP resources to be drained. These IPs must be valid static external IPs that have been assigned to the NAT. These IPs should be used for updating/patching a NAT only.
     *
     * Generated from protobuf field <code>repeated string drain_nat_ips = 235643079;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDrainNatIps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->drain_nat_ips = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>bool enable_endpoint_independent_mapping = 259441819;</code>
     * @return bool
     */
    public function getEnableEndpointIndependentMapping()
    {
        return $this->enable_endpoint_independent_mapping;
    }

    /**
     * Generated from protobuf field <code>bool enable_endpoint_independent_mapping = 259441819;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableEndpointIndependentMapping($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_endpoint_independent_mapping = $var;

        return $this;
    }

    /**
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 icmp_idle_timeout_sec = 3647562;</code>
     * @return int
     */
    public function getIcmpIdleTimeoutSec()
    {
        return $this->icmp_idle_timeout_sec;
    }

    /**
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 icmp_idle_timeout_sec = 3647562;</code>
     * @param int $var
     * @return $this
     */
    public function setIcmpIdleTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->icmp_idle_timeout_sec = $var;

        return $this;
    }

    /**
     * Configure logging on this NAT.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNatLogConfig log_config = 82864285;</code>
     * @return \Google\Cloud\Compute\V1\RouterNatLogConfig
     */
    public function getLogConfig()
    {
        return isset($this->log_config) ? $this->log_config : null;
    }

    public function hasLogConfig()
    {
        return isset($this->log_config);
    }

    public function clearLogConfig()
    {
        unset($this->log_config);
    }

    /**
     * Configure logging on this NAT.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNatLogConfig log_config = 82864285;</code>
     * @param \Google\Cloud\Compute\V1\RouterNatLogConfig $var
     * @return $this
     */
    public function setLogConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Compute\V1\RouterNatLogConfig::class);
        $this->log_config = $var;

        return $this;
    }

    /**
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     *
     * Generated from protobuf field <code>int32 min_ports_per_vm = 186193587;</code>
     * @return int
     */
    public function getMinPortsPerVm()
    {
        return $this->min_ports_per_vm;
    }

    /**
     * Minimum number of ports allocated to a VM from this NAT config. If not set, a default number of ports is allocated to a VM. This is rounded up to the nearest power of 2. For example, if the value of this field is 50, at least 64 ports are allocated to a VM.
     *
     * Generated from protobuf field <code>int32 min_ports_per_vm = 186193587;</code>
     * @param int $var
     * @return $this
     */
    public function setMinPortsPerVm($var)
    {
        GPBUtil::checkInt32($var);
        $this->min_ports_per_vm = $var;

        return $this;
    }

    /**
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Unique name of this Nat service. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Generated from protobuf field <code>string name = 3373707;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Specify the NatIpAllocateOption, which can take one of the following values:
     * - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.
     * - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNat.NatIpAllocateOption nat_ip_allocate_option = 161291389;</code>
     * @return int
     */
    public function getNatIpAllocateOption()
    {
        return $this->nat_ip_allocate_option;
    }

    /**
     * Specify the NatIpAllocateOption, which can take one of the following values:
     * - MANUAL_ONLY: Uses only Nat IP addresses provided by customers. When there are not enough specified Nat IPs, the Nat service fails for new VMs.
     * - AUTO_ONLY: Nat IPs are allocated by Google Cloud Platform; customers can't specify any Nat IPs. When choosing AUTO_ONLY, then nat_ip should be empty.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNat.NatIpAllocateOption nat_ip_allocate_option = 161291389;</code>
     * @param int $var
     * @return $this
     */
    public function setNatIpAllocateOption($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\RouterNat\NatIpAllocateOption::class);
        $this->nat_ip_allocate_option = $var;

        return $this;
    }

    /**
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     *
     * Generated from protobuf field <code>repeated string nat_ips = 117635086;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getNatIps()
    {
        return $this->nat_ips;
    }

    /**
     * A list of URLs of the IP resources used for this Nat service. These IP addresses must be valid static external IP addresses assigned to the project.
     *
     * Generated from protobuf field <code>repeated string nat_ips = 117635086;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setNatIps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->nat_ips = $arr;

        return $this;
    }

    /**
     * Specify the Nat option, which can take one of the following values:
     * - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.
     * - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.
     * - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     * @return int
     */
    public function getSourceSubnetworkIpRangesToNat()
    {
        return $this->source_subnetwork_ip_ranges_to_nat;
    }

    /**
     * Specify the Nat option, which can take one of the following values:
     * - ALL_SUBNETWORKS_ALL_IP_RANGES: All of the IP ranges in every Subnetwork are allowed to Nat.
     * - ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES: All of the primary IP ranges in every Subnetwork are allowed to Nat.
     * - LIST_OF_SUBNETWORKS: A list of Subnetworks are allowed to Nat (specified in the field subnetwork below) The default is SUBNETWORK_IP_RANGE_TO_NAT_OPTION_UNSPECIFIED. Note that if this field contains ALL_SUBNETWORKS_ALL_IP_RANGES or ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any other Router.Nat section in any Router for this network in this region.
     *
     * Generated from protobuf field <code>.google.cloud.compute.v1.RouterNat.SourceSubnetworkIpRangesToNat source_subnetwork_ip_ranges_to_nat = 252213211;</code>
     * @param int $var
     * @return $this
     */
    public function setSourceSubnetworkIpRangesToNat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Compute\V1\RouterNat\SourceSubnetworkIpRangesToNat::class);
        $this->source_subnetwork_ip_ranges_to_nat = $var;

        return $this;
    }

    /**
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 147417669;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSubnetworks()
    {
        return $this->subnetworks;
    }

    /**
     * A list of Subnetwork resources whose traffic should be translated by NAT Gateway. It is used only when LIST_OF_SUBNETWORKS is selected for the SubnetworkIpRangeToNatOption above.
     *
     * Generated from protobuf field <code>repeated .google.cloud.compute.v1.RouterNatSubnetworkToNat subnetworks = 147417669;</code>
     * @param \Google\Cloud\Compute\V1\RouterNatSubnetworkToNat[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSubnetworks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Compute\V1\RouterNatSubnetworkToNat::class);
        $this->subnetworks = $arr;

        return $this;
    }

    /**
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     *
     * Generated from protobuf field <code>int32 tcp_established_idle_timeout_sec = 223098349;</code>
     * @return int
     */
    public function getTcpEstablishedIdleTimeoutSec()
    {
        return $this->tcp_established_idle_timeout_sec;
    }

    /**
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     *
     * Generated from protobuf field <code>int32 tcp_established_idle_timeout_sec = 223098349;</code>
     * @param int $var
     * @return $this
     */
    public function setTcpEstablishedIdleTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->tcp_established_idle_timeout_sec = $var;

        return $this;
    }

    /**
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     * @return int
     */
    public function getTcpTransitoryIdleTimeoutSec()
    {
        return $this->tcp_transitory_idle_timeout_sec;
    }

    /**
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 tcp_transitory_idle_timeout_sec = 205028774;</code>
     * @param int $var
     * @return $this
     */
    public function setTcpTransitoryIdleTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->tcp_transitory_idle_timeout_sec = $var;

        return $this;
    }

    /**
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 udp_idle_timeout_sec = 64919878;</code>
     * @return int
     */
    public function getUdpIdleTimeoutSec()
    {
        return $this->udp_idle_timeout_sec;
    }

    /**
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     *
     * Generated from protobuf field <code>int32 udp_idle_timeout_sec = 64919878;</code>
     * @param int $var
     * @return $this
     */
    public function setUdpIdleTimeoutSec($var)
    {
        GPBUtil::checkInt32($var);
        $this->udp_idle_timeout_sec = $var;

        return $this;
    }

}

