<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/profile_service.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request body of the `SearchProfiles` call.
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.SearchProfilesRequest</code>
 */
class SearchProfilesRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The resource name of the tenant to search within.
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $parent = '';
    /**
     * Required. The meta information collected about the profile search user. This is used
     * to improve the search quality of the service. These values are provided by
     * users, and must be precise and consistent.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.RequestMetadata request_metadata = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $request_metadata = null;
    /**
     * Search query to execute. See [ProfileQuery][google.cloud.talent.v4beta1.ProfileQuery] for more details.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.ProfileQuery profile_query = 3;</code>
     */
    private $profile_query = null;
    /**
     * A limit on the number of profiles returned in the search results.
     * A value above the default value 10 can increase search response time.
     * The maximum value allowed is 100. Otherwise an error is thrown.
     *
     * Generated from protobuf field <code>int32 page_size = 4;</code>
     */
    private $page_size = 0;
    /**
     * The pageToken, similar to offset enables users of the API to paginate
     * through the search results. To retrieve the first page of results, set the
     * pageToken to empty. The search response includes a
     * [nextPageToken][google.cloud.talent.v4beta1.SearchProfilesResponse.next_page_token] field that can be
     * used to populate the pageToken field for the next page of results. Using
     * pageToken instead of offset increases the performance of the API,
     * especially compared to larger offset values.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     */
    private $page_token = '';
    /**
     * An integer that specifies the current offset (that is, starting result) in
     * search results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token] is unset.
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     * For example, 0 means to search from the first profile, and 10 means to
     * search from the 11th profile. This can be used for pagination, for example
     * pageSize = 10 and offset = 10 means to search from the second page.
     *
     * Generated from protobuf field <code>int32 offset = 6;</code>
     */
    private $offset = 0;
    /**
     * This flag controls the spell-check feature. If `false`, the
     * service attempts to correct a misspelled query.
     * For example, "enginee" is corrected to "engineer".
     *
     * Generated from protobuf field <code>bool disable_spell_check = 7;</code>
     */
    private $disable_spell_check = false;
    /**
     * The criteria that determines how search results are sorted.
     * Defaults is "relevance desc" if no value is specified.
     * Supported options are:
     * * "relevance desc": By descending relevance, as determined by the API
     *    algorithms.
     * * "update_date desc": Sort by [Profile.update_time][google.cloud.talent.v4beta1.Profile.update_time] in descending order
     *   (recently updated profiles first).
     * * "create_date desc": Sort by [Profile.create_time][google.cloud.talent.v4beta1.Profile.create_time] in descending order
     *   (recently created profiles first).
     * * "first_name": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name] in
     *   ascending order.
     * * "first_name desc": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name]
     *   in descending order.
     * * "last_name": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name] in
     *   ascending order.
     * * "last_name desc": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name]
     *   in ascending order.
     *
     * Generated from protobuf field <code>string order_by = 8;</code>
     */
    private $order_by = '';
    /**
     * When sort by field is based on alphabetical order, sort values case
     * sensitively (based on ASCII) when the value is set to true. Default value
     * is case in-sensitive sort (false).
     *
     * Generated from protobuf field <code>bool case_sensitive_sort = 9;</code>
     */
    private $case_sensitive_sort = false;
    /**
     * A list of expressions specifies histogram requests against matching
     * profiles for [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
     * The expression syntax looks like a function definition with parameters.
     * Function syntax: function_name(histogram_facet[, list of buckets])
     * Data types:
     * * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
     * * String: string like "any string with backslash escape for quote(\")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets. For example, [1, 2, 3] and ["one", "two", "three"].
     * Built-in constants:
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     * Built-in functions:
     * * bucket(start, end[, label])
     * Bucket build-in function creates a bucket with range of [start, end). Note
     * that the end is exclusive.
     * For example, bucket(1, MAX, "positive number") or bucket(1, 10).
     * Histogram Facets:
     * * admin1: Admin1 is a global placeholder for referring to state, province,
     * or the particular term a country uses to define the geographic structure
     * below the country level. Examples include states codes such as "CA", "IL",
     * "NY", and provinces, such as "BC".
     * * locality: Locality is a global placeholder for referring to city, town,
     * or the particular term a country uses to define the geographic structure
     * below the admin1 level. Examples include city names such as
     * "Mountain View" and "New York".
     * * extended_locality: Extended locality is concatenated version of admin1
     * and locality with comma separator. For example, "Mountain View, CA" and
     * "New York, NY".
     * * postal_code: Postal code of profile which follows locale code.
     * * country: Country code (ISO-3166-1 alpha-2 code) of profile, such as US,
     *  JP, GB.
     * * job_title: Normalized job titles specified in EmploymentHistory.
     * * company_name: Normalized company name of profiles to match on.
     * * institution: The school name. For example, "MIT",
     * "University of California, Berkeley"
     * * degree: Highest education degree in ISCED code. Each value in degree
     * covers a specific level of education, without any expansion to upper nor
     * lower levels of education degree.
     * * experience_in_months: experience in months. 0 means 0 month to 1 month
     * (exclusive).
     * * application_date: The application date specifies application start dates.
     * See [ApplicationDateFilter][google.cloud.talent.v4beta1.ApplicationDateFilter] for more details.
     * * application_outcome_notes: The application outcome reason specifies the
     * reasons behind the outcome of the job application.
     * See [ApplicationOutcomeNotesFilter][google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter] for more details.
     * * application_job_title: The application job title specifies the job
     * applied for in the application.
     * See [ApplicationJobFilter][google.cloud.talent.v4beta1.ApplicationJobFilter] for more details.
     * * hirable_status: Hirable status specifies the profile's hirable status.
     * * string_custom_attribute: String custom attributes. Values can be accessed
     * via square bracket notation like string_custom_attribute["key1"].
     * * numeric_custom_attribute: Numeric custom attributes. Values can be
     * accessed via square bracket notation like numeric_custom_attribute["key1"].
     * Example expressions:
     * * count(admin1)
     * * count(experience_in_months, [bucket(0, 12, "1 year"),
     * bucket(12, 36, "1-3 years"), bucket(36, MAX, "3+ years")])
     * * count(string_custom_attribute["assigned_recruiter"])
     * * count(numeric_custom_attribute["favorite_number"],
     * [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.HistogramQuery histogram_queries = 10;</code>
     */
    private $histogram_queries;
    /**
     * An id that uniquely identifies the result set of a
     * [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles] call. The id should be
     * retrieved from the
     * [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] message returned from a previous
     * invocation of [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles].
     * A result set is an ordered list of search results.
     * If this field is not set, a new result set is computed based on the
     * [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query].  A new [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] is returned as a handle to
     * access this result set.
     * If this field is set, the service will ignore the resource and
     * [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query] values, and simply retrieve a page of results from the
     * corresponding result set.  In this case, one and only one of [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token]
     * or [offset][google.cloud.talent.v4beta1.SearchProfilesRequest.offset] must be set.
     * A typical use case is to invoke [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest] without this
     * field, then use the resulting [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] in
     * [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] to page through the results.
     *
     * Generated from protobuf field <code>string result_set_id = 12;</code>
     */
    private $result_set_id = '';
    /**
     * This flag is used to indicate whether the service will attempt to
     * understand synonyms and terms related to the search query or treat the
     * query "as is" when it generates a set of results. By default this flag is
     * set to false, thus allowing expanded results to also be returned. For
     * example a search for "software engineer" might also return candidates who
     * have experience in jobs similar to software engineer positions. By setting
     * this flag to true, the service will only attempt to deliver candidates has
     * software engineer in his/her global fields by treating "software engineer"
     * as a keyword.
     * It is recommended to provide a feature in the UI (such as a checkbox) to
     * allow recruiters to set this flag to true if they intend to search for
     * longer boolean strings.
     *
     * Generated from protobuf field <code>bool strict_keywords_search = 13;</code>
     */
    private $strict_keywords_search = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The resource name of the tenant to search within.
     *           The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     *           "projects/foo/tenants/bar".
     *     @type \Google\Cloud\Talent\V4beta1\RequestMetadata $request_metadata
     *           Required. The meta information collected about the profile search user. This is used
     *           to improve the search quality of the service. These values are provided by
     *           users, and must be precise and consistent.
     *     @type \Google\Cloud\Talent\V4beta1\ProfileQuery $profile_query
     *           Search query to execute. See [ProfileQuery][google.cloud.talent.v4beta1.ProfileQuery] for more details.
     *     @type int $page_size
     *           A limit on the number of profiles returned in the search results.
     *           A value above the default value 10 can increase search response time.
     *           The maximum value allowed is 100. Otherwise an error is thrown.
     *     @type string $page_token
     *           The pageToken, similar to offset enables users of the API to paginate
     *           through the search results. To retrieve the first page of results, set the
     *           pageToken to empty. The search response includes a
     *           [nextPageToken][google.cloud.talent.v4beta1.SearchProfilesResponse.next_page_token] field that can be
     *           used to populate the pageToken field for the next page of results. Using
     *           pageToken instead of offset increases the performance of the API,
     *           especially compared to larger offset values.
     *     @type int $offset
     *           An integer that specifies the current offset (that is, starting result) in
     *           search results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token] is unset.
     *           The maximum allowed value is 5000. Otherwise an error is thrown.
     *           For example, 0 means to search from the first profile, and 10 means to
     *           search from the 11th profile. This can be used for pagination, for example
     *           pageSize = 10 and offset = 10 means to search from the second page.
     *     @type bool $disable_spell_check
     *           This flag controls the spell-check feature. If `false`, the
     *           service attempts to correct a misspelled query.
     *           For example, "enginee" is corrected to "engineer".
     *     @type string $order_by
     *           The criteria that determines how search results are sorted.
     *           Defaults is "relevance desc" if no value is specified.
     *           Supported options are:
     *           * "relevance desc": By descending relevance, as determined by the API
     *              algorithms.
     *           * "update_date desc": Sort by [Profile.update_time][google.cloud.talent.v4beta1.Profile.update_time] in descending order
     *             (recently updated profiles first).
     *           * "create_date desc": Sort by [Profile.create_time][google.cloud.talent.v4beta1.Profile.create_time] in descending order
     *             (recently created profiles first).
     *           * "first_name": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name] in
     *             ascending order.
     *           * "first_name desc": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name]
     *             in descending order.
     *           * "last_name": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name] in
     *             ascending order.
     *           * "last_name desc": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name]
     *             in ascending order.
     *     @type bool $case_sensitive_sort
     *           When sort by field is based on alphabetical order, sort values case
     *           sensitively (based on ASCII) when the value is set to true. Default value
     *           is case in-sensitive sort (false).
     *     @type \Google\Cloud\Talent\V4beta1\HistogramQuery[]|\Google\Protobuf\Internal\RepeatedField $histogram_queries
     *           A list of expressions specifies histogram requests against matching
     *           profiles for [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
     *           The expression syntax looks like a function definition with parameters.
     *           Function syntax: function_name(histogram_facet[, list of buckets])
     *           Data types:
     *           * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
     *           * String: string like "any string with backslash escape for quote(\")."
     *           * Number: whole number and floating point number like 10, -1 and -0.01.
     *           * List: list of elements with comma(,) separator surrounded by square
     *           brackets. For example, [1, 2, 3] and ["one", "two", "three"].
     *           Built-in constants:
     *           * MIN (minimum number similar to java Double.MIN_VALUE)
     *           * MAX (maximum number similar to java Double.MAX_VALUE)
     *           Built-in functions:
     *           * bucket(start, end[, label])
     *           Bucket build-in function creates a bucket with range of [start, end). Note
     *           that the end is exclusive.
     *           For example, bucket(1, MAX, "positive number") or bucket(1, 10).
     *           Histogram Facets:
     *           * admin1: Admin1 is a global placeholder for referring to state, province,
     *           or the particular term a country uses to define the geographic structure
     *           below the country level. Examples include states codes such as "CA", "IL",
     *           "NY", and provinces, such as "BC".
     *           * locality: Locality is a global placeholder for referring to city, town,
     *           or the particular term a country uses to define the geographic structure
     *           below the admin1 level. Examples include city names such as
     *           "Mountain View" and "New York".
     *           * extended_locality: Extended locality is concatenated version of admin1
     *           and locality with comma separator. For example, "Mountain View, CA" and
     *           "New York, NY".
     *           * postal_code: Postal code of profile which follows locale code.
     *           * country: Country code (ISO-3166-1 alpha-2 code) of profile, such as US,
     *            JP, GB.
     *           * job_title: Normalized job titles specified in EmploymentHistory.
     *           * company_name: Normalized company name of profiles to match on.
     *           * institution: The school name. For example, "MIT",
     *           "University of California, Berkeley"
     *           * degree: Highest education degree in ISCED code. Each value in degree
     *           covers a specific level of education, without any expansion to upper nor
     *           lower levels of education degree.
     *           * experience_in_months: experience in months. 0 means 0 month to 1 month
     *           (exclusive).
     *           * application_date: The application date specifies application start dates.
     *           See [ApplicationDateFilter][google.cloud.talent.v4beta1.ApplicationDateFilter] for more details.
     *           * application_outcome_notes: The application outcome reason specifies the
     *           reasons behind the outcome of the job application.
     *           See [ApplicationOutcomeNotesFilter][google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter] for more details.
     *           * application_job_title: The application job title specifies the job
     *           applied for in the application.
     *           See [ApplicationJobFilter][google.cloud.talent.v4beta1.ApplicationJobFilter] for more details.
     *           * hirable_status: Hirable status specifies the profile's hirable status.
     *           * string_custom_attribute: String custom attributes. Values can be accessed
     *           via square bracket notation like string_custom_attribute["key1"].
     *           * numeric_custom_attribute: Numeric custom attributes. Values can be
     *           accessed via square bracket notation like numeric_custom_attribute["key1"].
     *           Example expressions:
     *           * count(admin1)
     *           * count(experience_in_months, [bucket(0, 12, "1 year"),
     *           bucket(12, 36, "1-3 years"), bucket(36, MAX, "3+ years")])
     *           * count(string_custom_attribute["assigned_recruiter"])
     *           * count(numeric_custom_attribute["favorite_number"],
     *           [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])
     *     @type string $result_set_id
     *           An id that uniquely identifies the result set of a
     *           [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles] call. The id should be
     *           retrieved from the
     *           [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] message returned from a previous
     *           invocation of [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles].
     *           A result set is an ordered list of search results.
     *           If this field is not set, a new result set is computed based on the
     *           [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query].  A new [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] is returned as a handle to
     *           access this result set.
     *           If this field is set, the service will ignore the resource and
     *           [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query] values, and simply retrieve a page of results from the
     *           corresponding result set.  In this case, one and only one of [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token]
     *           or [offset][google.cloud.talent.v4beta1.SearchProfilesRequest.offset] must be set.
     *           A typical use case is to invoke [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest] without this
     *           field, then use the resulting [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] in
     *           [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] to page through the results.
     *     @type bool $strict_keywords_search
     *           This flag is used to indicate whether the service will attempt to
     *           understand synonyms and terms related to the search query or treat the
     *           query "as is" when it generates a set of results. By default this flag is
     *           set to false, thus allowing expanded results to also be returned. For
     *           example a search for "software engineer" might also return candidates who
     *           have experience in jobs similar to software engineer positions. By setting
     *           this flag to true, the service will only attempt to deliver candidates has
     *           software engineer in his/her global fields by treating "software engineer"
     *           as a keyword.
     *           It is recommended to provide a feature in the UI (such as a checkbox) to
     *           allow recruiters to set this flag to true if they intend to search for
     *           longer boolean strings.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\ProfileService::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The resource name of the tenant to search within.
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The resource name of the tenant to search within.
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. The meta information collected about the profile search user. This is used
     * to improve the search quality of the service. These values are provided by
     * users, and must be precise and consistent.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.RequestMetadata request_metadata = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Talent\V4beta1\RequestMetadata
     */
    public function getRequestMetadata()
    {
        return isset($this->request_metadata) ? $this->request_metadata : null;
    }

    public function hasRequestMetadata()
    {
        return isset($this->request_metadata);
    }

    public function clearRequestMetadata()
    {
        unset($this->request_metadata);
    }

    /**
     * Required. The meta information collected about the profile search user. This is used
     * to improve the search quality of the service. These values are provided by
     * users, and must be precise and consistent.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.RequestMetadata request_metadata = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Talent\V4beta1\RequestMetadata $var
     * @return $this
     */
    public function setRequestMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\RequestMetadata::class);
        $this->request_metadata = $var;

        return $this;
    }

    /**
     * Search query to execute. See [ProfileQuery][google.cloud.talent.v4beta1.ProfileQuery] for more details.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.ProfileQuery profile_query = 3;</code>
     * @return \Google\Cloud\Talent\V4beta1\ProfileQuery
     */
    public function getProfileQuery()
    {
        return isset($this->profile_query) ? $this->profile_query : null;
    }

    public function hasProfileQuery()
    {
        return isset($this->profile_query);
    }

    public function clearProfileQuery()
    {
        unset($this->profile_query);
    }

    /**
     * Search query to execute. See [ProfileQuery][google.cloud.talent.v4beta1.ProfileQuery] for more details.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.ProfileQuery profile_query = 3;</code>
     * @param \Google\Cloud\Talent\V4beta1\ProfileQuery $var
     * @return $this
     */
    public function setProfileQuery($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\ProfileQuery::class);
        $this->profile_query = $var;

        return $this;
    }

    /**
     * A limit on the number of profiles returned in the search results.
     * A value above the default value 10 can increase search response time.
     * The maximum value allowed is 100. Otherwise an error is thrown.
     *
     * Generated from protobuf field <code>int32 page_size = 4;</code>
     * @return int
     */
    public function getPageSize()
    {
        return $this->page_size;
    }

    /**
     * A limit on the number of profiles returned in the search results.
     * A value above the default value 10 can increase search response time.
     * The maximum value allowed is 100. Otherwise an error is thrown.
     *
     * Generated from protobuf field <code>int32 page_size = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setPageSize($var)
    {
        GPBUtil::checkInt32($var);
        $this->page_size = $var;

        return $this;
    }

    /**
     * The pageToken, similar to offset enables users of the API to paginate
     * through the search results. To retrieve the first page of results, set the
     * pageToken to empty. The search response includes a
     * [nextPageToken][google.cloud.talent.v4beta1.SearchProfilesResponse.next_page_token] field that can be
     * used to populate the pageToken field for the next page of results. Using
     * pageToken instead of offset increases the performance of the API,
     * especially compared to larger offset values.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     * @return string
     */
    public function getPageToken()
    {
        return $this->page_token;
    }

    /**
     * The pageToken, similar to offset enables users of the API to paginate
     * through the search results. To retrieve the first page of results, set the
     * pageToken to empty. The search response includes a
     * [nextPageToken][google.cloud.talent.v4beta1.SearchProfilesResponse.next_page_token] field that can be
     * used to populate the pageToken field for the next page of results. Using
     * pageToken instead of offset increases the performance of the API,
     * especially compared to larger offset values.
     *
     * Generated from protobuf field <code>string page_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setPageToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_token = $var;

        return $this;
    }

    /**
     * An integer that specifies the current offset (that is, starting result) in
     * search results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token] is unset.
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     * For example, 0 means to search from the first profile, and 10 means to
     * search from the 11th profile. This can be used for pagination, for example
     * pageSize = 10 and offset = 10 means to search from the second page.
     *
     * Generated from protobuf field <code>int32 offset = 6;</code>
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * An integer that specifies the current offset (that is, starting result) in
     * search results. This field is only considered if [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token] is unset.
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     * For example, 0 means to search from the first profile, and 10 means to
     * search from the 11th profile. This can be used for pagination, for example
     * pageSize = 10 and offset = 10 means to search from the second page.
     *
     * Generated from protobuf field <code>int32 offset = 6;</code>
     * @param int $var
     * @return $this
     */
    public function setOffset($var)
    {
        GPBUtil::checkInt32($var);
        $this->offset = $var;

        return $this;
    }

    /**
     * This flag controls the spell-check feature. If `false`, the
     * service attempts to correct a misspelled query.
     * For example, "enginee" is corrected to "engineer".
     *
     * Generated from protobuf field <code>bool disable_spell_check = 7;</code>
     * @return bool
     */
    public function getDisableSpellCheck()
    {
        return $this->disable_spell_check;
    }

    /**
     * This flag controls the spell-check feature. If `false`, the
     * service attempts to correct a misspelled query.
     * For example, "enginee" is corrected to "engineer".
     *
     * Generated from protobuf field <code>bool disable_spell_check = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableSpellCheck($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_spell_check = $var;

        return $this;
    }

    /**
     * The criteria that determines how search results are sorted.
     * Defaults is "relevance desc" if no value is specified.
     * Supported options are:
     * * "relevance desc": By descending relevance, as determined by the API
     *    algorithms.
     * * "update_date desc": Sort by [Profile.update_time][google.cloud.talent.v4beta1.Profile.update_time] in descending order
     *   (recently updated profiles first).
     * * "create_date desc": Sort by [Profile.create_time][google.cloud.talent.v4beta1.Profile.create_time] in descending order
     *   (recently created profiles first).
     * * "first_name": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name] in
     *   ascending order.
     * * "first_name desc": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name]
     *   in descending order.
     * * "last_name": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name] in
     *   ascending order.
     * * "last_name desc": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name]
     *   in ascending order.
     *
     * Generated from protobuf field <code>string order_by = 8;</code>
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }

    /**
     * The criteria that determines how search results are sorted.
     * Defaults is "relevance desc" if no value is specified.
     * Supported options are:
     * * "relevance desc": By descending relevance, as determined by the API
     *    algorithms.
     * * "update_date desc": Sort by [Profile.update_time][google.cloud.talent.v4beta1.Profile.update_time] in descending order
     *   (recently updated profiles first).
     * * "create_date desc": Sort by [Profile.create_time][google.cloud.talent.v4beta1.Profile.create_time] in descending order
     *   (recently created profiles first).
     * * "first_name": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name] in
     *   ascending order.
     * * "first_name desc": Sort by [PersonName.PersonStructuredName.given_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.given_name]
     *   in descending order.
     * * "last_name": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name] in
     *   ascending order.
     * * "last_name desc": Sort by [PersonName.PersonStructuredName.family_name][google.cloud.talent.v4beta1.PersonName.PersonStructuredName.family_name]
     *   in ascending order.
     *
     * Generated from protobuf field <code>string order_by = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setOrderBy($var)
    {
        GPBUtil::checkString($var, True);
        $this->order_by = $var;

        return $this;
    }

    /**
     * When sort by field is based on alphabetical order, sort values case
     * sensitively (based on ASCII) when the value is set to true. Default value
     * is case in-sensitive sort (false).
     *
     * Generated from protobuf field <code>bool case_sensitive_sort = 9;</code>
     * @return bool
     */
    public function getCaseSensitiveSort()
    {
        return $this->case_sensitive_sort;
    }

    /**
     * When sort by field is based on alphabetical order, sort values case
     * sensitively (based on ASCII) when the value is set to true. Default value
     * is case in-sensitive sort (false).
     *
     * Generated from protobuf field <code>bool case_sensitive_sort = 9;</code>
     * @param bool $var
     * @return $this
     */
    public function setCaseSensitiveSort($var)
    {
        GPBUtil::checkBool($var);
        $this->case_sensitive_sort = $var;

        return $this;
    }

    /**
     * A list of expressions specifies histogram requests against matching
     * profiles for [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
     * The expression syntax looks like a function definition with parameters.
     * Function syntax: function_name(histogram_facet[, list of buckets])
     * Data types:
     * * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
     * * String: string like "any string with backslash escape for quote(\")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets. For example, [1, 2, 3] and ["one", "two", "three"].
     * Built-in constants:
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     * Built-in functions:
     * * bucket(start, end[, label])
     * Bucket build-in function creates a bucket with range of [start, end). Note
     * that the end is exclusive.
     * For example, bucket(1, MAX, "positive number") or bucket(1, 10).
     * Histogram Facets:
     * * admin1: Admin1 is a global placeholder for referring to state, province,
     * or the particular term a country uses to define the geographic structure
     * below the country level. Examples include states codes such as "CA", "IL",
     * "NY", and provinces, such as "BC".
     * * locality: Locality is a global placeholder for referring to city, town,
     * or the particular term a country uses to define the geographic structure
     * below the admin1 level. Examples include city names such as
     * "Mountain View" and "New York".
     * * extended_locality: Extended locality is concatenated version of admin1
     * and locality with comma separator. For example, "Mountain View, CA" and
     * "New York, NY".
     * * postal_code: Postal code of profile which follows locale code.
     * * country: Country code (ISO-3166-1 alpha-2 code) of profile, such as US,
     *  JP, GB.
     * * job_title: Normalized job titles specified in EmploymentHistory.
     * * company_name: Normalized company name of profiles to match on.
     * * institution: The school name. For example, "MIT",
     * "University of California, Berkeley"
     * * degree: Highest education degree in ISCED code. Each value in degree
     * covers a specific level of education, without any expansion to upper nor
     * lower levels of education degree.
     * * experience_in_months: experience in months. 0 means 0 month to 1 month
     * (exclusive).
     * * application_date: The application date specifies application start dates.
     * See [ApplicationDateFilter][google.cloud.talent.v4beta1.ApplicationDateFilter] for more details.
     * * application_outcome_notes: The application outcome reason specifies the
     * reasons behind the outcome of the job application.
     * See [ApplicationOutcomeNotesFilter][google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter] for more details.
     * * application_job_title: The application job title specifies the job
     * applied for in the application.
     * See [ApplicationJobFilter][google.cloud.talent.v4beta1.ApplicationJobFilter] for more details.
     * * hirable_status: Hirable status specifies the profile's hirable status.
     * * string_custom_attribute: String custom attributes. Values can be accessed
     * via square bracket notation like string_custom_attribute["key1"].
     * * numeric_custom_attribute: Numeric custom attributes. Values can be
     * accessed via square bracket notation like numeric_custom_attribute["key1"].
     * Example expressions:
     * * count(admin1)
     * * count(experience_in_months, [bucket(0, 12, "1 year"),
     * bucket(12, 36, "1-3 years"), bucket(36, MAX, "3+ years")])
     * * count(string_custom_attribute["assigned_recruiter"])
     * * count(numeric_custom_attribute["favorite_number"],
     * [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.HistogramQuery histogram_queries = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getHistogramQueries()
    {
        return $this->histogram_queries;
    }

    /**
     * A list of expressions specifies histogram requests against matching
     * profiles for [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest].
     * The expression syntax looks like a function definition with parameters.
     * Function syntax: function_name(histogram_facet[, list of buckets])
     * Data types:
     * * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
     * * String: string like "any string with backslash escape for quote(\")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets. For example, [1, 2, 3] and ["one", "two", "three"].
     * Built-in constants:
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     * Built-in functions:
     * * bucket(start, end[, label])
     * Bucket build-in function creates a bucket with range of [start, end). Note
     * that the end is exclusive.
     * For example, bucket(1, MAX, "positive number") or bucket(1, 10).
     * Histogram Facets:
     * * admin1: Admin1 is a global placeholder for referring to state, province,
     * or the particular term a country uses to define the geographic structure
     * below the country level. Examples include states codes such as "CA", "IL",
     * "NY", and provinces, such as "BC".
     * * locality: Locality is a global placeholder for referring to city, town,
     * or the particular term a country uses to define the geographic structure
     * below the admin1 level. Examples include city names such as
     * "Mountain View" and "New York".
     * * extended_locality: Extended locality is concatenated version of admin1
     * and locality with comma separator. For example, "Mountain View, CA" and
     * "New York, NY".
     * * postal_code: Postal code of profile which follows locale code.
     * * country: Country code (ISO-3166-1 alpha-2 code) of profile, such as US,
     *  JP, GB.
     * * job_title: Normalized job titles specified in EmploymentHistory.
     * * company_name: Normalized company name of profiles to match on.
     * * institution: The school name. For example, "MIT",
     * "University of California, Berkeley"
     * * degree: Highest education degree in ISCED code. Each value in degree
     * covers a specific level of education, without any expansion to upper nor
     * lower levels of education degree.
     * * experience_in_months: experience in months. 0 means 0 month to 1 month
     * (exclusive).
     * * application_date: The application date specifies application start dates.
     * See [ApplicationDateFilter][google.cloud.talent.v4beta1.ApplicationDateFilter] for more details.
     * * application_outcome_notes: The application outcome reason specifies the
     * reasons behind the outcome of the job application.
     * See [ApplicationOutcomeNotesFilter][google.cloud.talent.v4beta1.ApplicationOutcomeNotesFilter] for more details.
     * * application_job_title: The application job title specifies the job
     * applied for in the application.
     * See [ApplicationJobFilter][google.cloud.talent.v4beta1.ApplicationJobFilter] for more details.
     * * hirable_status: Hirable status specifies the profile's hirable status.
     * * string_custom_attribute: String custom attributes. Values can be accessed
     * via square bracket notation like string_custom_attribute["key1"].
     * * numeric_custom_attribute: Numeric custom attributes. Values can be
     * accessed via square bracket notation like numeric_custom_attribute["key1"].
     * Example expressions:
     * * count(admin1)
     * * count(experience_in_months, [bucket(0, 12, "1 year"),
     * bucket(12, 36, "1-3 years"), bucket(36, MAX, "3+ years")])
     * * count(string_custom_attribute["assigned_recruiter"])
     * * count(numeric_custom_attribute["favorite_number"],
     * [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.HistogramQuery histogram_queries = 10;</code>
     * @param \Google\Cloud\Talent\V4beta1\HistogramQuery[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setHistogramQueries($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\HistogramQuery::class);
        $this->histogram_queries = $arr;

        return $this;
    }

    /**
     * An id that uniquely identifies the result set of a
     * [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles] call. The id should be
     * retrieved from the
     * [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] message returned from a previous
     * invocation of [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles].
     * A result set is an ordered list of search results.
     * If this field is not set, a new result set is computed based on the
     * [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query].  A new [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] is returned as a handle to
     * access this result set.
     * If this field is set, the service will ignore the resource and
     * [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query] values, and simply retrieve a page of results from the
     * corresponding result set.  In this case, one and only one of [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token]
     * or [offset][google.cloud.talent.v4beta1.SearchProfilesRequest.offset] must be set.
     * A typical use case is to invoke [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest] without this
     * field, then use the resulting [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] in
     * [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] to page through the results.
     *
     * Generated from protobuf field <code>string result_set_id = 12;</code>
     * @return string
     */
    public function getResultSetId()
    {
        return $this->result_set_id;
    }

    /**
     * An id that uniquely identifies the result set of a
     * [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles] call. The id should be
     * retrieved from the
     * [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] message returned from a previous
     * invocation of [SearchProfiles][google.cloud.talent.v4beta1.ProfileService.SearchProfiles].
     * A result set is an ordered list of search results.
     * If this field is not set, a new result set is computed based on the
     * [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query].  A new [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] is returned as a handle to
     * access this result set.
     * If this field is set, the service will ignore the resource and
     * [profile_query][google.cloud.talent.v4beta1.SearchProfilesRequest.profile_query] values, and simply retrieve a page of results from the
     * corresponding result set.  In this case, one and only one of [page_token][google.cloud.talent.v4beta1.SearchProfilesRequest.page_token]
     * or [offset][google.cloud.talent.v4beta1.SearchProfilesRequest.offset] must be set.
     * A typical use case is to invoke [SearchProfilesRequest][google.cloud.talent.v4beta1.SearchProfilesRequest] without this
     * field, then use the resulting [result_set_id][google.cloud.talent.v4beta1.SearchProfilesRequest.result_set_id] in
     * [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse] to page through the results.
     *
     * Generated from protobuf field <code>string result_set_id = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setResultSetId($var)
    {
        GPBUtil::checkString($var, True);
        $this->result_set_id = $var;

        return $this;
    }

    /**
     * This flag is used to indicate whether the service will attempt to
     * understand synonyms and terms related to the search query or treat the
     * query "as is" when it generates a set of results. By default this flag is
     * set to false, thus allowing expanded results to also be returned. For
     * example a search for "software engineer" might also return candidates who
     * have experience in jobs similar to software engineer positions. By setting
     * this flag to true, the service will only attempt to deliver candidates has
     * software engineer in his/her global fields by treating "software engineer"
     * as a keyword.
     * It is recommended to provide a feature in the UI (such as a checkbox) to
     * allow recruiters to set this flag to true if they intend to search for
     * longer boolean strings.
     *
     * Generated from protobuf field <code>bool strict_keywords_search = 13;</code>
     * @return bool
     */
    public function getStrictKeywordsSearch()
    {
        return $this->strict_keywords_search;
    }

    /**
     * This flag is used to indicate whether the service will attempt to
     * understand synonyms and terms related to the search query or treat the
     * query "as is" when it generates a set of results. By default this flag is
     * set to false, thus allowing expanded results to also be returned. For
     * example a search for "software engineer" might also return candidates who
     * have experience in jobs similar to software engineer positions. By setting
     * this flag to true, the service will only attempt to deliver candidates has
     * software engineer in his/her global fields by treating "software engineer"
     * as a keyword.
     * It is recommended to provide a feature in the UI (such as a checkbox) to
     * allow recruiters to set this flag to true if they intend to search for
     * longer boolean strings.
     *
     * Generated from protobuf field <code>bool strict_keywords_search = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setStrictKeywordsSearch($var)
    {
        GPBUtil::checkBool($var);
        $this->strict_keywords_search = $var;

        return $this;
    }

}

